/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.ant;

import java.io.File;
import java.util.Vector;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import de.tu_bs.coobra.ObjectChangeAwareHelper;
import de.uni_paderborn.fujaba.app.KernelInterfaceImpl;
import de.uni_paderborn.fujaba.preferences.LoggingPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import de.upb.lib.plugins.PluginManager;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author$
 * @version   $Revision$ $Date$
 */
public abstract class AbstractGenTask extends Task
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (AbstractGenTask.class);

   /**
    * the destination directoryname .
    */
   private String destDirname = null;


   /**
    * Get the destDirname attribute of the AbstractGenTask object
    *
    * @return   The destDirname value
    */
   public String getDestDirname()
   {
      return destDirname;
   }


   /**
    * @param destDirname  The destDirname to set.
    */
   public void setDestDirname (String destDirname)
   {
      this.destDirname = destDirname;
   }


   /**
    * the destination directoryname .
    */
   private String pluginFolder = null;


   /**
    * The method executing the task
    *
    * @throws BuildException  if codegeneration fails
    */
   public void execute() throws BuildException
   {
      if (log.isDebugEnabled())
      {
         log.debug (this + ".execute()");
      }

      log ("destDirname=" + destDirname);

      try
      {
         validate();

         // ===== Configure log4j NOW so that framework ready if calls are made
         // to it
         try
         {
            // Turn off log4j default init, not necessary
            System.setProperty ("log4j.defaultInitOverride", "true");
            // Set the property dir as a system property so that it can be used in
            // the log4j config file
            String propertyDir = PreferencesProperties.getPropertyDir();
            String fileSeparator = Character.toString (File.separatorChar);
            // Trim file separator char to match how user.dir etc are stored
            if (propertyDir.endsWith (fileSeparator))
            {
               propertyDir = propertyDir.substring (0, propertyDir.length() - 1);
            }
            System.setProperty ("fujaba.propertydir", propertyDir);
            LoggingPreferences.get(); // .configureLog4J();
         }
         catch (Throwable t)
         {
            t.printStackTrace();
         }

         // ===== end of log4j configuration

         ObjectChangeAwareHelper.setRelaxed (true);

         if (pluginFolder != null)
         {
            // initialize plugin manager
            PluginManager pluginManager = KernelInterfaceImpl.get().getManager();
            // load the plugins
            Vector folders = new Vector();
            folders.add (pluginFolder);
            pluginManager.scanPlugins (folders);
            pluginManager.loadPlugins();
         }

         executeImpl();

         // shutting down log4j
         LogManager.shutdown();
      }
      catch (Throwable t)
      {
         log.error (t.getMessage(), t);
         throw new BuildException ("Codegeneration was not successful (ERROR: \"" + t.getMessage() + "\")!", t);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected abstract void executeImpl();


   /**
    * validate task input configuration.
    *
    * @throws BuildException  if configuration is invalid .
    */
   protected void validate()
   {
      if (getDestDirname() != null)
      {
         File destinationDir = new File (getDestDirname());

         // ensure existing destinationDir
         if (!destinationDir.exists())
         {
            if (log.isDebugEnabled())
            {
               log.debug ("creating destinationDir:'"
                  + destinationDir.getAbsolutePath() + "'.");
            }

            boolean success = destinationDir.mkdirs();
            if (!success)
            {
               throw new BuildException (
                  "failed to create destinationDir:'"
                  + destinationDir.getAbsolutePath() + "'.");
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public String toString()
   {
      StringBuffer result = new StringBuffer();

      result.append (this.getClass().getName());
      result.append ("[");
      result.append ("]");

      return result.toString();
   }


   /**
    * Sets the pluginFolder attribute of the AbstractGenTask object
    *
    * @param pluginFolder  The new pluginFolder value
    */
   public void setPluginFolder (String pluginFolder)
   {
      this.pluginFolder = pluginFolder;
   }


   /**
    * Get the pluginFolder attribute of the AbstractGenTask object
    *
    * @return   The pluginFolder value
    */
   public String getPluginFolder()
   {
      return pluginFolder;
   }
}

/*
 * $Log$
 * Revision 1.1.2.9  2006/07/10 08:05:34  cschneid
 * sysouts removed, exceptions printed (instead of ignoring completely), caption changed to 'Fujaba 4'
 *
 */
