/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;


/**
 * Dialog for the environment options.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.26 $
 */
public class ProjectDialog extends FujabaDialog
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   OptionsPanelProject optionsProject = new OptionsPanelProject();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton browseButton = new JButton ("Browse...");


   /**
    * Constructor for class ProjectDialog
    *
    * @param frame  No description provided
    */
   public ProjectDialog (JFrame frame)
   {
      super (frame, "Project Options", true);

      JPanel panel = this.guiPanelOkCancelHelp();
      panel.add (browseButton);

      JPanel container = new JPanel();
      container.setLayout (new BorderLayout());
      container.add (optionsProject, BorderLayout.CENTER);
      container.add (panel, BorderLayout.SOUTH);
      getContentPane().add (container);
      pack();
      this.unparse();

      optionsProject.addActionListener (new OKActionListener (this));

      browseButton.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               browse();
            }
         }
         );

      // added to tranfer the focus to the TextField where to enter the new
      // name for the project. This Listener also selects all the text which
      // is by default UNAMED PROJECT.
      addFocusListener (
         new FocusAdapter()
         {
            public void focusGained (FocusEvent e)
            {
               optionsProject.requestFocus();
            }
         }
         );
   }


   /**
    * Set all the options of inserted panels, because there options may have changed.
    */
   public void unparse()
   {
      optionsProject.setPreferences();
   }


   /**
    * Set all the optionsProject-Data to the current data of the dialog
    */
   public void parse()
   {
      optionsProject.okPressed();
   }


   /**
    * Opens a JFileChooser so you can browse to get your favourite directory.
    */
   void browse()
   {
      JFileChooser jf = new JFileChooser();
      jf.setFileSelectionMode (JFileChooser.DIRECTORIES_ONLY);
      int opt = jf.showDialog (this, "Choose Root Directory");

      if (opt == JFileChooser.APPROVE_OPTION)
      {
         optionsProject.setRootDir (jf.getSelectedFile().getAbsolutePath());
      }
   }
}


/**
 * This listener is for the two TextFields in this OptionsPanelProject and will fire the OK-action
 * when enter is pressed.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.26 $
 */
class OKActionListener implements ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   ProjectDialog pd;


   /**
    * The ProjectDialog has to be transferred where finally the actionOKButton-method will
    * be called.
    *
    * @param pd  No description provided
    */
   OKActionListener (ProjectDialog pd)
   {
      this.pd = pd;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      pd.actionOkButton();
   }
}

/*
 * $Log: ProjectDialog.java,v $
 * Revision 1.26  2004/10/20 17:49:24  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
