/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app.action;

import java.awt.event.ActionEvent;

import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.InternalFrame;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Deletes the current diagram.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.19 $
 */
public class DeleteDiagramAction extends AbstractAction
{
   /**
    * Deletes currently selected diagrams. Calls
    *
    * @param e  No description provided
    * @see      de.uni_paderborn.fujaba.asg.ASGDiagram#delete
    */
   public void actionPerformed (ActionEvent e)
   {
      FrameMain frameMain = FrameMain.get();

      DefaultMutableTreeNode result;
      try
      {
         result = frameMain.getSelectedTreeNode();
      }
      catch (Exception except)
      {
         result = null;
      }

      int answer = JOptionPane.showConfirmDialog (frameMain,
         "Do you really want to delete the selected diagram(s)?",
         "Delete diagram(s)",
         JOptionPane.YES_NO_OPTION);
      if (result != null && answer == JOptionPane.YES_OPTION)
      {
         //	save reference to current diagram
         ASGDiagram currentDiag = UMLProject.get().getCurrentDiagram();

         try
         {
            ASGDiagram diagram = null;
            DefaultMutableTreeNode leaf = result.getFirstLeaf();

            while (leaf != null && result.isNodeDescendant (leaf))
            {
               Object userObject = leaf.getUserObject();

               if (userObject instanceof ASGDiagram)
               {
                  diagram = (ASGDiagram) userObject;
                  diagram.delete();
               }

               leaf = leaf.getNextLeaf();
            }

            frameMain.createNewTreeItems();

            // leave former current diagram
            if (currentDiag != null)
            {
               frameMain.doEverythingOnExit (currentDiag);
               UMLProject.get().setCurrentDiagram (null); // delete reference
            }

            if (diagram != null)
            {
               final InternalFrame internalFrame = FrameMain.get().getInternalFrame (diagram);
               if (internalFrame != null)
               {
                  internalFrame.dispose();
               }
            }
         }
         catch (Exception tmpException)
         {
            tmpException.printStackTrace();
         } // end of catch
      }
      else if (result == null)
      {
         JOptionPane.showMessageDialog (frameMain,
            "No diagram is selected in the tree!",
            "Delete diagram",
            JOptionPane.INFORMATION_MESSAGE,
            null);
      }
   } // actionPerformed

}

/*
 * $Log: DeleteDiagramAction.java,v $
 * Revision 1.19  2004/11/18 19:06:09  cschneid
 * mdi behaviour fixed
 *
 */
