/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app.action;

import java.awt.event.ActionEvent;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;


/**
 * Export and Compile the current project
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.11 $
 */
public class ExportAndCompileAction extends AbstractAction
{
   /**
    * Keeps the state of the ExportAndCompileAction for other actions
    */
   private boolean success = false;


   /**
    * Returns the state of ExportAndCompileAction, true if the export was successful, else
    * false
    *
    * @return   The successful value
    */
   public boolean isSuccessful()
   {
      return success;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      FrameMain frameMain = FrameMain.get();

      ExportFilesAction myexport = new ExportFilesAction();
      myexport.actionPerformed (e);

      if (myexport.isSuccessful())
      {
         CompileAction mycompile = new CompileAction();
         mycompile.actionPerformed (e);
         this.success = true;
      }
      else
      {
//         JOptionPane.showMessageDialog (frameMain, "Export & Compile canceled!", "Export & Compile Project",
//            JOptionPane.WARNING_MESSAGE);
         frameMain.setStatusLabel ("Export & Compile canceled");
      }
   } // actionPerformed

}

/*
 * $Log: ExportAndCompileAction.java,v $
 * Revision 1.11  2005/02/14 14:28:01  cschneid
 * introduced message view, getParentElement() for FElement, code generation and compiler messages in message view
 *
 */
