/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app.action;

import java.awt.event.ActionEvent;
import java.util.*;

import javax.swing.AbstractAction;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.codegen.*;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.preferences.*;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Export a class to java sources.
 *
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.19.2.3 $
 */
public class ExportJavaAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    *
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {
      if (event != null)
      {
         Object source = event.getSource();
         if (source instanceof Iterator)
         {
            Iterator iter = (Iterator) source;

            // if the iterator is empty, we create a new one,
            // which contains the current diagram
            // because maybe someone tries to export the
            // corresponding UML class
            if (!iter.hasNext())
            {
               ASGDiagram currentDiagram = UMLProject.get().getCurrentDiagram();
               if (currentDiagram != null)
               {
                  HashSet set = new HashSet();
                  set.add (currentDiagram);
                  iter = set.iterator();
               }
            }

            while (iter.hasNext())
            {
               Object obj = iter.next();

               // if source is an activity-diagram, we export
               // its corresponding class
               if (obj instanceof UMLActivityDiagram)
               {
                  UMLMethod storyMethod =  ((UMLActivityDiagram) obj).getStoryMethod();

                  // alternative way to retrieve the method
                  if (storyMethod == null)
                  {
                     storyMethod =  ((UMLActivityDiagram) obj).getStartActivity().getSpec();
                  }

                  if (storyMethod != null)
                  {
                     FClass correspondingClass = storyMethod.getParent();
                     if (correspondingClass != null)
                     {
                        obj = correspondingClass;
                     }
                  }
               }

               if (obj instanceof FClass)
               {
                  Map target = CodeGenPreferences.get().getSelectedCodeGenTargetNames();
                  Iterator iter2 = target.keySet().iterator();

                  while (iter2.hasNext())
                  {
                     String key = (String) iter2.next();
                     Boolean bool = (Boolean) target.get (key);
                     if (bool.booleanValue())
                     {
                        CodeGenFactory.get().setCurrentTarget (key);
                        // Get all possible strategies of current
                        // target.
                        Iterator targetIter = CodeGenFactory.get().getCurrentTarget().iteratorOfCodeGenTargetEntry();
                        while (targetIter.hasNext())
                        {
                           CodeGenTargetEntry tmpEntry = (CodeGenTargetEntry) targetIter.next();
                           String strategyName = tmpEntry.getStrategyName();
                           String visitorName = tmpEntry.getVisitorName();
                           // set strategy
                           CodeGenStrategy tmpStrategy = CodeGenFactory.get().getFromCodeGenStrategy (strategyName);
                           CodeGenFactory.get().setCurrentStrategy (tmpStrategy);
                           // set visitor
                           CodeGenVisitor tmpVisitor = tmpStrategy.getFromCodeGenVisitor (visitorName);
                           tmpStrategy.setCurrentVisitor (tmpVisitor);

                           CodeGenFactory.get().generateFElement ( ((FClass) obj).getFFile(), true);
                        }
                     }
                  }
               }
            }
         }
      }
   }
}

/*
 * $Log: ExportJavaAction.java,v $
 * Revision 1.19.2.3  2005/10/10 10:54:11  fklar
 * added ability to export the corresponding UML class with the 'export class'-button when editing a Fujaba StoryDiagram
 *
 */
