/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app.action;

import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.actions.RemoveBackupDiagramsAction;


/**
 * Save an existing project (with FileDialog).
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.12.2.1 $
 */
public class SaveProjectAsAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      FrameMain myFrame = FrameMain.get();

      if (FujabaChangeManager.getVMRepository() != null &&
          (FujabaChangeManager.getVMRepository().isConnected() ||
         FujabaChangeManager.getVMRepository().isServerRepository()))
      {
         String message;
         if (FujabaChangeManager.getVMRepository().isServerRepository())
         {
            message = "Saving a server repository as FPR does not allow clients to reconnect after loading! The " +
               "FPR-File must be imported by a new server. Continue?";
         }
         else
         {
            message = "Saving as FPR does not allow to reconnect to a server! The FPR can only be used as " +
               "offline backup or may be imported as a new server. Continue?";
         }
         if (JOptionPane.showConfirmDialog (myFrame, message, "Save FPR", JOptionPane.YES_NO_OPTION) != JOptionPane.YES_OPTION)
         {
            return;
         }
      }

      File file = UMLProject.get().getFile();
      JFileChooser fileChooser = myFrame.getFileChooser();

      if (file == null)
      {
         file = new File (System.getProperty ("user.dir"), "noname.fpr.gz");
      }

      fileChooser.setCurrentDirectory (file);
      fileChooser.setSelectedFile (file);
      fileChooser.setFileFilter (myFrame.getFilterFujabaProject());
      fileChooser.setFileSelectionMode (JFileChooser.FILES_ONLY);

      if (fileChooser.showSaveDialog (myFrame.getFrame()) == JFileChooser.APPROVE_OPTION)
      {
         String filename = fileChooser.getSelectedFile().getAbsolutePath();
         if ( (filename.toLowerCase().indexOf (".fpr") > 0) &&
             (filename.toLowerCase().indexOf (".fpr.gz") < 0) &&
             (!fileChooser.getSelectedFile().exists()))
         {
            // the user already has appended an .fpr
            filename += ".gz";
         }
         else if (filename.toLowerCase().indexOf (".fpr.gz") < 0)
         {
            filename += ".fpr.gz";
         }

         File fileProject = new File (filename);
         try
         {
            myFrame.setCursorWait();
            try
            {
               try
               {
                  removeParseTrees();
                  UMLProject.get().saveProject (fileProject);
                  myFrame.setSaveAction (null); //Is FPR Project now
               }
               catch (Exception tmpException)
               {
                  tmpException.printStackTrace();
               } // end of catch
               myFrame.showTitle();
            }
            finally
            {
               myFrame.setCursorDefault();
            }
         }
         catch (Exception except)
         {
            JOptionPane.showMessageDialog (myFrame.getFrame(), except.getMessage(),
               "Warning: Can't save", JOptionPane.WARNING_MESSAGE);
         }
      }
   } // actionPerformed


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void removeParseTrees()
   {
      Action action = new RemoveBackupDiagramsAction();
      action.actionPerformed (null);
   } // removeallparsetrees

}

/*
 * $Log: SaveProjectAsAction.java,v $
 * Revision 1.12.2.1  2006/04/12 10:09:21  creckord
 * UMLProject.file updated properly on load/save
 * FrameMain.saveAction set correctly
 * libraries updated
 *
 */
