/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app.messages;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;


/**
 * Warning class provides some warning message methods for NewClassDiagActiopn and NewActivityDiagAction
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.8 $
 */
public class WarningMessages
{
   /**
    * Shows a warning message, needed for NewClassDiagAction and NewActivityDiagAction
    *
    * @param frame        No description provided
    * @param diagramType  No description provided
    * @param name         No description provided
    */
   public final static void warnDoubleIdentifiedDiagram (FrameMain frame, String diagramType, String name)
   {
      JOptionPane.showMessageDialog (frame,
         "It already exists an " + diagramType + " diagram with the name '" + name + "'.\n" +
         "Please enter another one.",
         "Double named " + diagramType + " diagram",
         JOptionPane.WARNING_MESSAGE,
         null);
   }


   /**
    * Shows a warning message, needed for NewClassDiagAction and NewActivityDiagAction
    *
    * @param frame        No description provided
    * @param diagramType  No description provided
    */
   public final static void warnUnnamedDiagram (FrameMain frame, String diagramType)
   {
      JOptionPane.showMessageDialog (frame,
         "You entered no name for the " + diagramType + " diagram\n" +
         "Please enter one.",
         "Unnamed " + diagramType + " diagram",
         JOptionPane.WARNING_MESSAGE,
         null);
   }

}

/*
 * $Log: WarningMessages.java,v $
 * Revision 1.8  2004/10/20 17:49:26  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
