/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.asg;



/**
 * Utility class for reusable diagram methodes. Each diagram should have one.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.6 $
 */
public abstract class ASGUtility
{

   /**
    * Constructor for abstract class ASGUtility
    *
    * @param diagram  No description provided
    */
   public ASGUtility (ASGDiagram diagram)
   {
      //initialize assoc to ASGDiagram
      this.setDiagram (diagram);

   } // constructor


   /**
    * <pre>
    *             1    utility    0..1
    * ASGDiagram ---------------------- ASGUtility
    *             diagram      utility
    * </pre>
    */
   private ASGDiagram diagram;


   /**
    * Sets the diagram attribute of the ASGUtility object
    *
    * @param value  The new diagram value
    * @return       No description provided
    */
   public boolean setDiagram (ASGDiagram value)
   {
      boolean changed = false;
      if (this.diagram != value)
      {
         if (this.diagram != null)
         {
            ASGDiagram oldValue = this.diagram;
            this.diagram = null;
            oldValue.setUtility (null);
         }
         this.diagram = value;
         if (value != null)
         {
            value.setUtility (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * Get the diagram attribute of the ASGUtility object
    *
    * @return   The diagram value
    */
   public ASGDiagram getDiagram()
   {
      return this.diagram;
   }

}

/*
 * $Log: ASGUtility.java,v $
 * Revision 1.6  2004/11/22 19:04:51  lowende
 * Some javadoc corrections.
 *
 */
