/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.basic;

import java.util.Comparator;

import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.uml.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.9.2.4 $
 */
public class FujabaComparator
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   static Logger logger = Logger.getLogger (FujabaComparator.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   final static Comparator lessString;

   static
   {
      lessString = createLessString();
   }
   // ######################################################################

   /**
    * Get the lessString attribute of the FujabaComparator class
    *
    * @return   The lessString value
    */
   public static Comparator getLessString()
   {
      return lessString;
   }


   /**
    * Get the lessString attribute of the FujabaComparator class
    *
    * @return   The lessString value
    */
   private static Comparator createLessString()
   {
      return
         new Comparator()
         {
            public boolean equals (Object obj)
            {
               return this.compare (this, obj) == 0;
            }


            public int compare (Object o1, Object o2)
            {
               int result = 0;
               if (o1 == null)
               {
                  if (o2 != null)
                  {
                     result = -1;
                  }
               }
               else if (o2 == null)
               {
                  result = 1;
               }
               else
               {
                  result =  ((String) o1).compareTo ((String) o2);
               }
               return result;
            }
         };
   }


   /**
    * Get the lessType attribute of the FujabaComparator class
    *
    * @return   The lessType value
    */
   public static Comparator getLessType()
   {
      return
         new Comparator()
         {
            public final int compare (final Object o1, final Object o2)
            {
               final UMLType t1 = (UMLType) o1;
               final UMLType t2 = (UMLType) o2;
               int result = 0;
               if (t1 == null)
               {
                  if (t2 != null)
                  {
                     result = -1;
                  }
               }
               else if (t2 == null)
               {
                  result = 1;
               }
               else if (t1 instanceof UMLBaseTypes)
               {
                  if (t2 instanceof UMLBaseTypes)
                  {
                     result = lessString.compare (t1.getName(), t2.getName());
                  }
                  else
                  {
                     result = -1;
                  }
               }
               else if (t2 instanceof UMLBaseTypes)
               {
                  result = 1;
               }
               else if (t1 instanceof UMLClass)
               {
                  if (t2 instanceof UMLClass)
                  {
                     result = lessString.compare (t1.getName(), t2.getName());
                     if (result == 0)
                     {
                        final UMLClass c1 = (UMLClass) t1;
                        final UMLClass c2 = (UMLClass) t2;

                        result = lessString.compare (c1.getFullClassName(), c2.getFullClassName());
                     }
                  }
                  else
                  { // t2 is an instance of UMLArray

                     result = -1; // UMLClass is less than UMLArray
                  }
               }
               else if (t2 instanceof UMLClass)
               { // t1 is an instance of UMLArray

                  // UMLClass is less than UMLArray
                  result = 1;
               }
               else if (t1 instanceof UMLArray)
               {
                  if (t2 instanceof UMLArray)
                  {
                     this.compare ( ((UMLArray) t1).getBaseType(),  ((UMLArray) t2).getBaseType());
                  }
                  else
                  {
                     result = 1;
                  }
               }
               else if (t2 instanceof UMLArray)
               {
                  result = -1;
               }
               else
               {
                  // this case shouldn't occure!!!!
                  // only UMLBaseTypes, UMLClass and UMLArray are
                  // classes derived from UMLType
                  result = lessString.compare (t1.getName(), t2.getName());

                  if (logger.isEnabledFor (Priority.WARN))
                  {
                     logger.warn ("unknown implementations of interface 'UMLType': t1 '" +
                        t1.getClass().getName() +
                        "', t2 '" + t2.getClass().getName() + "'.");
                  }
               }
               return result;
            }
         };
   }

   // ######################################################################

   /**
    * Get the lessClassName attribute of the FujabaComparator class
    *
    * @return   The lessClassName value
    */
   public static Comparator getLessClassName()
   {
      return
         new Comparator()
         {
            public boolean equals (Object obj)
            {
               return this.compare (this, obj) == 0;
            }


            public int compare (Object o1, Object o2)
            {
               return o1.getClass().getName().compareTo (o2.getClass().getName());
            }
         };
   }

   // ######################################################################

   /**
    * Get the lessBasicIncr attribute of the FujabaComparator class
    *
    * @return   The lessBasicIncr value
    */
   public static Comparator getLessBasicIncr()
   {
      return
         new Comparator()
         {
            public boolean equals (Object obj)
            {
               return this.compare (this, obj) == 0;
            }


            public int compare (Object o1, Object o2)
            {
               return  ((BasicIncrement) o1).getID().compareTo ( ((BasicIncrement) o2).getID());
            }
         };
   }

   // ######################################################################

   /**
    * Get the packageComparator attribute of the FujabaComparator class
    *
    * @return   The packageComparator value
    */
   public static Comparator getPackageComparator()
   {
      return
         new Comparator()
         {
            public boolean equals (Object obj)
            {
               return this.compare (this, obj) == 0;
            }


            public int compare (Object o1, Object o2)
            {
               return  ((FPackage) o1).getFullPackageName().compareTo ( ((FPackage) o2).getFullPackageName());
            }
         };
   }
}

/*
 * $Log: FujabaComparator.java,v $
 * Revision 1.9.2.4  2005/06/08 12:20:54  lowende
 * Some compile warnings removed.
 *
 */
