/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.basic;

import java.awt.Rectangle;
import java.util.Iterator;

import javax.swing.JComponent;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListenerHelper;
import de.uni_paderborn.fujaba.metamodel.FDiagramItem;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.*;
import de.upb.tools.fca.FLinkedList;


/**
 * Created by IntelliJ IDEA. User: Leif Geiger Date: Aug 5, 2003 Time: 11:51:27 PM To change
 * this template use Options | File Templates.
 *
 * @author    $Author: joerg $
 * @version   $Revision: 1.11.2.1 $
 */
public class IncrSelector
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (IncrSelector.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FLinkedList lastSelected = null;


   /**
    * The provided service. Select an UML Increment and its diagram.
    *
    * @param incrID  No description provided
    */
   public void selectIncrByID (String incrID)
   {
      UMLProject project = UMLProject.get();

      FrameMain.get().setCursorWait();

      try
      {
         if (incrID != null)
         {
            ASGElement incr = project.searchID (incrID);
            gotoElement (incr);
         } // if

         UMLProject.get().refreshDisplay();
      } // try
      catch (Exception e)
      {
         e.printStackTrace();
      }
      FrameMain.get().setCursorDefault();

   } // selectIncrByID


   /**
    * @param element  to be shown on screen
    */
   public void gotoElement (ASGElement element)
   {
      try
      {
         removeLastSelected();
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
         log.error ("Cannot deselect increment.");
      }

      if (element != null)
      {
         if (element instanceof UMLTransitionGuard)
         {
            element =  ((UMLTransitionGuard) element).getRevGuard();
         }

         ASGDiagram diagram = null;
         FElement diagElement = element;
         while (diagElement != null && diagram == null)
         {
            if (diagElement instanceof ASGDiagram)
            {
               diagram = (ASGDiagram) diagElement;
            }
            else if (diagElement instanceof FDiagramItem)
            {
               FDiagramItem item = (FDiagramItem) diagElement;
               diagram = (ASGDiagram) item.getFFirstFromDiagrams();
            } // if
            diagElement = diagElement.getParentElement();
         }

         if (diagram instanceof UMLStoryPattern)
         {
            UMLStoryActivity storyAct =  ((UMLStoryPattern) diagram).getRevStoryPattern();
            if (element == diagram)
            {
               element = storyAct;
            }
            diagram = storyAct.getFirstFromDiagrams();
         }

         if (diagram != null)
         {
            FrameMain.get().selectTreeItem (diagram);
            FrameMain.get().showDiagram (diagram);
         }
         lastSelected = new FLinkedList();
         Iterator iter = element.iteratorOfFsaObjects();
         JComponent comp = null;
         while (iter.hasNext())
         {
            FSAObject fsaObject = (FSAObject) iter.next();
            comp = fsaObject.getJComponent();
            lastSelected.add (comp);
            SelectionListenerHelper.setSelected (comp, true);
            if (element.getFSAInterface().getMainFsaName().equals (fsaObject.getPropertyName()))
            {
               comp.scrollRectToVisible (new Rectangle (0, 0, comp.getWidth(), comp.getHeight()));
            }
         }
      } // if
   }


   /**
    * Constructor for class IncrSelector
    */
   private IncrSelector() { } // constructor


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static IncrSelector selector = new IncrSelector();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static IncrSelector get()
   {
      return selector;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void removeLastSelected()
   {
      if (getLastSelected() != null)
      {
         Iterator iter = getLastSelected().iterator();
         while (iter.hasNext())
         {
            JComponent comp = (JComponent) iter.next();
            SelectionListenerHelper.setSelected (comp, false);
         }

      }
      setLastSelected (null);
   } // removeLastSelected


   /**
    * Sets the lastSelected attribute of the FujabaRMIServiceImpl object
    *
    * @param lastSelected  The new lastSelected value
    */
   public void setLastSelected (FLinkedList lastSelected)
   {
      this.lastSelected = lastSelected;
   }


   /**
    * Get the lastSelected attribute of the FujabaRMIServiceImpl object
    *
    * @return   The lastSelected value
    */
   public FLinkedList getLastSelected()
   {
      return this.lastSelected;
   }

}

/*
 * $Log: IncrSelector.java,v $
 * Revision 1.11.2.1  2005/07/04 15:16:27  joerg
 * Moved usecase package to plugin module.
 *
 */
