/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.basic;

import javax.swing.*;


/**
 * An abstract class that you subclass to perform GUI-related work in a dedicated thread. For
 * instructions on using this class, see <a href="http://java.sun.com/products/jfc/swingdoc-current/threads2.html">
 * Swing Documents: Threads<\a> <br>
 * Note: This file is taken from the Tech Topics This file is not included in the swing package!!!
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.12 $
 */
public abstract class SwingWorker
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Object value;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Thread thread;


   /**
    * Start a thread that will call the <code>construct</code> method and then exit.
    */
   public SwingWorker()
   {
      final Runnable doFinished =
         new Runnable()
         {
            public void run()
            {
               finished();
            }
         };

      Runnable doConstruct =
         new Runnable()
         {
            public void run()
            {
               try
               {
                  synchronized (SwingWorker.this)
                  {
                     value = construct();
                     thread = null;
                  }
               }
               finally
               {
                  SwingUtilities.invokeLater (doFinished);
               }
            }
         };

      thread = new Thread (doConstruct);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void start()
   {
      thread.start();
   } // start


   /**
    * Compute the value to be returned by the <code>get</code> method.
    *
    * @return   No description provided
    */
   public abstract Object construct();


   /**
    * Called on the event dispatching thread (not on the worker thread) after the <code>construct</code>
    * method has returned.
    */
   public void finished()
   {
   } // finished


   /**
    * A new method that interrupts the worker thread. Call this method to force the worker
    * to abort what it's doing.
    */
   public void interrupt()
   {
      Thread t = thread;
      if (t != null)
      {
         t.interrupt();
      }
      thread = null;
   } // interrupt


   /**
    * Return the value created by the <code>construct</code> method.
    *
    * @return   No description provided
    */
   public Object get()
   {
      while (true)
      { // keep trying if we're interrupted

         Thread t;
         synchronized (SwingWorker.this)
         {
            t = thread;
            if (t == null)
            {
               return value;
            }
         }
         try
         {
            t.join();
         }
         catch (InterruptedException e)
         {
         }
      }
   } // get

}

/*
 * $Log: SwingWorker.java,v $
 * Revision 1.12  2004/10/20 17:49:28  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
