/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Iterator;

import de.uni_paderborn.fujaba.asg.ASGElementRef;
import de.uni_paderborn.fujaba.asg.ASGTransient;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FElementRef;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;


/**
 * @author    <a href="mailto:creckord@upb.de">Carsten Reckord</a>
 * @version   $Revision: 1.3 $
 */
public class AccessedElementRef extends ASGElementRef implements ASGTransient, FElementRef
{
   /**
    * Get the accessedElementRef attribute of the AccessedElementRef class
    *
    * @param element  No description provided
    * @return         The accessedElementRef value
    */
   public static AccessedElementRef getAccessedElementRef (FElement element)
   {
      AccessedElementRef ref = (AccessedElementRef) element.getFromFElementReferences (AccessedElementRef.class.getName());
      if (ref == null)
      {
         ref = new AccessedElementRef();
         ref.setElement (element);
      }
      return ref;
   }


   /**
    * <pre>
    *                     0..1          Assoc          0..n
    * AccessedElementRef ----------------------------------- AccessMethodRef
    *                     accessedElementRef      accessMethodRef
    * </pre>
    */
   private FHashSet accessMethodRef;


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToAccessMethodRef (AccessMethodRef value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.accessMethodRef == null)
         {
            this.accessMethodRef = new FHashSet(); // or FTreeSet () or FLinkedList ()
         }

         changed = this.accessMethodRef.add (value);
         if (changed)
         {
            value.setAccessedElementRef (this);
         }

      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInAccessMethodRef (AccessMethodRef value)
   {
      return  ( (this.accessMethodRef != null) &&
          (value != null) &&
         this.accessMethodRef.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfAccessMethodRef()
   {
      return  ( (this.accessMethodRef == null)
         ? FEmptyIterator.get()
         : this.accessMethodRef.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromAccessMethodRef()
   {
      AccessMethodRef tmpValue;
      Iterator iter = this.iteratorOfAccessMethodRef();
      while (iter.hasNext())
      {
         tmpValue = (AccessMethodRef) iter.next();
         this.removeFromAccessMethodRef (tmpValue);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromAccessMethodRef (AccessMethodRef value)
   {
      boolean changed = false;
      if ( (this.accessMethodRef != null) &&  (value != null))
      {

         changed = this.accessMethodRef.remove (value);
         if (changed)
         {
            value.removeYou();
         }

      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfAccessMethodRef()
   {
      return  ( (this.accessMethodRef == null)
         ? 0
         : this.accessMethodRef.size());
   }


   /**
    * <pre>
    *                     0..1         unnamed association          n
    * AccessedElementRef --------------------------------------------- StatechartMethodRef
    *                     accessedElementRef      statechartMethodRef
    * </pre>
    */
   private FHashSet statechartMethodRef;


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToStatechartMethodRef (StatechartMethodRef value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.statechartMethodRef == null)
         {
            this.statechartMethodRef = new FHashSet(); // or FTreeSet () or FLinkedList ()
         }

         changed = this.statechartMethodRef.add (value);
         if (changed)
         {
            value.setAccessedElementRef (this);
         }

      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInStatechartMethodRef (StatechartMethodRef value)
   {
      return  ( (this.statechartMethodRef != null) &&
          (value != null) &&
         this.statechartMethodRef.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfStatechartMethodRef()
   {
      return  ( (this.statechartMethodRef == null)
         ? FEmptyIterator.get()
         : this.statechartMethodRef.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromStatechartMethodRef()
   {
      StatechartMethodRef tmpValue;
      Iterator iter = this.iteratorOfStatechartMethodRef();
      while (iter.hasNext())
      {
         tmpValue = (StatechartMethodRef) iter.next();
         this.removeFromStatechartMethodRef (tmpValue);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromStatechartMethodRef (StatechartMethodRef value)
   {
      boolean changed = false;
      if ( (this.statechartMethodRef != null) &&  (value != null))
      {

         changed = this.statechartMethodRef.remove (value);
         if (changed)
         {
            value.setAccessedElementRef (null);
         }

      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfStatechartMethodRef()
   {
      return  ( (this.statechartMethodRef == null)
         ? 0
         : this.statechartMethodRef.size());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      removeAllFromAccessMethodRef();
      removeAllFromStatechartMethodRef();
   }
}

/*
 * $Log: AccessedElementRef.java,v $
 * Revision 1.3  2004/10/20 17:49:38  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
