/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;



/**
 * @author    <a href="mailto:creckord@upb.de">Carsten Reckord</a>
 * @version   $Revision: 1.2 $
 */

public abstract class CodeGenFragment
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final String name;


   /**
    * Constructor for class CodeGenFragment
    */
   public CodeGenFragment()
   {
      this (null);
   }


   /**
    * Constructor for class CodeGenFragment
    *
    * @param name  No description provided
    */
   public CodeGenFragment (String name)
   {
      this.name = name;
   }


   /**
    * Get the name attribute of the CodeGenFragment object
    *
    * @return   The name value
    */
   public String getName()
   {
      return this.name;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient CodeGenFragment previousFragment; // reviousTokenerse CodeGenToken nextToken;


   /**
    * Get the previousToken attribute of the CodeGenToken object
    *
    * @return   The previousToken value
    */
   public CodeGenFragment getPreviousFragment()
   {
      return previousFragment;
   }


   /**
    * Sets the previousToken attribute of the CodeGenToken object
    *
    * @param previousToken  The new previousToken value
    */
   public void setPreviousFragment (CodeGenFragment previousToken)
   {
      if (this.previousFragment != previousToken)
      { // new partner

         CodeGenFragment oldPreviousToken = this.previousFragment;
         if (this.previousFragment != null)
         { // inform old partner

            this.previousFragment = null;
            oldPreviousToken.setNextFragment (null);
         }
         this.previousFragment = previousToken;
         if (previousToken != null)
         { // inform new partner

            this.previousFragment.setNextFragment (this);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient CodeGenFragment nextFragment; // reviousTokenerse CodeGenToken previousToken;


   /**
    * Get the nextToken attribute of the CodeGenToken object
    *
    * @return   The nextToken value
    */
   public CodeGenFragment getNextFragment()
   {
      return nextFragment;
   }


   /**
    * Sets the nextToken attribute of the CodeGenToken object
    *
    * @param nextToken  The new nextToken value
    */
   public void setNextFragment (CodeGenFragment nextToken)
   {
      if (this.nextFragment != nextToken)
      { // new partner

         CodeGenFragment oldNextToken = this.nextFragment;
         if (this.nextFragment != null)
         { // inform old partner

            this.nextFragment = null;
            oldNextToken.setPreviousFragment (null);
         }
         this.nextFragment = nextToken;
         if (nextToken != null)
         { // inform new partner

            this.nextFragment.setPreviousFragment (this);
         }
      }
   }


   /**
    * Get the sourceCode attribute of the CodeGenFragment object
    *
    * @return   The sourceCode value
    */
   public abstract String getSourceCode();
}

/*
 * $Log: CodeGenFragment.java,v $
 * Revision 1.2  2004/10/20 17:49:37  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
