/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;



/**
 * Class CodeGenTargetEntry
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.6 $ <h2> Associations </h2> <pre>
 *                /\  0..1                  Assoc                   n
 * CodeGenTarget <  >------------------------------------------------- CodeGenTargetEntry
 *                \/  codeGenTarget   {ordered,}   codeGenTargetEntry
 * </pre>
 */
public class CodeGenTargetEntry
{
   /**
    * Default Constructor
    */
   public CodeGenTargetEntry() { }


   /**
    * <pre>
    *                /\  0..1                  Assoc                   n
    * CodeGenTarget <  >------------------------------------------------- CodeGenTargetEntry
    *                \/  codeGenTarget   {ordered,}   codeGenTargetEntry
    * </pre>
    */
   private CodeGenTarget codeGenTarget;


   /**
    * @param value  The new codeGenTarget value
    * @return       No description provided
    * @see          #codeGenTarget
    */
   public boolean setCodeGenTarget (CodeGenTarget value)
   {
      boolean changed = false;
      if (this.codeGenTarget != value)
      {
         if (this.codeGenTarget != null)
         {
            CodeGenTarget oldValue = this.codeGenTarget;
            this.codeGenTarget = null;
            oldValue.removeFromCodeGenTargetEntry (this);
         }
         this.codeGenTarget = value;
         if (value != null)
         {
            value.addToCodeGenTargetEntry (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * @return   The codeGenTarget value
    * @see      #codeGenTarget
    */
   public CodeGenTarget getCodeGenTarget()
   {
      return this.codeGenTarget;
   }


   /**
    * UMLAttribute : 'strategyName : String '
    */
   private String strategyName;


   /**
    * Get the value of strategyName.
    *
    * @return   Value of strategyName.
    */
   public String getStrategyName()
   {
      return this.strategyName;
   }


   /**
    * Set the value of strategyName.
    *
    * @param strategyName  Value to assign to strategyName.
    */
   public void setStrategyName (String strategyName)
   {
      if (strategyName == null || !strategyName.equals (this.strategyName))
      {
         this.strategyName = strategyName;
      }
   }


   /**
    * UMLAttribute : 'visitorName : String '
    */
   private String visitorName;


   /**
    * Get the value of visitorName.
    *
    * @return   Value of visitorName.
    */
   public String getVisitorName()
   {
      return this.visitorName;
   }


   /**
    * Set the value of visitorName.
    *
    * @param visitorName  Value to assign to visitorName.
    */
   public void setVisitorName (String visitorName)
   {
      if (visitorName == null || !visitorName.equals (this.visitorName))
      {
         this.visitorName = visitorName;
      }
   }


   /**
    * UMLMethod: '+ removeYou (): Void'.
    */
   public void removeYou()
   {
      CodeGenTarget tmpCodeGenTarget = getCodeGenTarget();
      if (tmpCodeGenTarget != null)
      {
         setCodeGenTarget (null);
      } // if
   }


   /**
    * @return   short string representation of current object
    */

   public String toString()
   {
      StringBuffer result = new StringBuffer();

      result.append ("CodeGenTargetEntry[strategy=");
      result.append (strategyName);
      result.append (",visitorName=");
      result.append (visitorName);
      result.append ("]");

      return result.toString();
   }
}

/*
 * $Log: CodeGenTargetEntry.java,v $
 * Revision 1.6  2004/10/20 17:49:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
