/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * Class FindLowerBoundIfClauseOOFunction
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.13.2.1 $
 */
public class FindLowerBoundIfClauseOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (FindLowerBoundIfClauseOOFunction.class);


   /**
    * Default Constructor
    */
   public FindLowerBoundIfClauseOOFunction() { }


   /**
    * Get the responsible attribute of the FindLowerBoundIfClauseOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.FIND_LOWER_BOUND_IF_CLAUSE.equals (methodName);
   }


   /**
    * if clause Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String objectName;
      FType objectType;
      String objectTypeName;
      String toCheckObjectName;
      int toCheckObjectType;
      String tmpVariableName;

      try
      {
         objectName = (String) param[0];
         objectType = (FType) param[1];
         objectTypeName = (String) param[2];
         toCheckObjectName = (String) param[3];
         toCheckObjectType =  ((Integer) param[4]).intValue();
         tmpVariableName = (String) param[5];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".findLowerBoundIfClause("
            + ",objectName=" + objectName
            + ",objectTypeName=" + objectTypeName
            + ",toCheckObjectName=" + toCheckObjectName
            + ",toCheckObjectType=" + toCheckObjectType
            + ",tmpVariableName=" + tmpVariableName
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" find lower bound for " + objectName));

      OOVariable uniqueVariable = null;
      OOExpression expr = null;

      uniqueVariable = OO.variable (CGU.upFirstChar (tmpVariableName), OOVariableType.iFujabaFor,
         CGU.upFirstChar (objectName));

      OOStatement.add (statements,  (objectType == null ? OO.varDecl (objectTypeName, uniqueVariable,
         OOIdentifierExpr.NULL_IDENTIFIER) :
         OO.varDecl (objectType, uniqueVariable,
         OOIdentifierExpr.NULL_IDENTIFIER)));

      if ( (toCheckObjectType == UMLObject.NORM) ||  (toCheckObjectType == UMLObject.OPTIONAL))
      {
         OOStatement.add (statements, OO.ifStat (OO.notNullExpr (toCheckObjectName)));
      }
      else
      {
         OOStatement.add (statements, OO.ifStat (OO.not (OO.call (toCheckObjectName, "isEmpty"))));
      }
      OOStatement.add (statements, OO.startBlock());

      if (toCheckObjectType == UMLObject.SET)
      {
         expr = OO.call (toCheckObjectName, "last");
      }
      else
      {
         expr = OO.identifier (toCheckObjectName);
      }
      OOStatement.add (statements, OO.assignStat (uniqueVariable, OO.typeCast (objectTypeName, expr)));
      OOStatement.add (statements, OO.endBlock ("if"));

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "FindLowerBoundIfClauseOOFunction[]";
   }
}

/*
 * $Log: FindLowerBoundIfClauseOOFunction.java,v $
 * Revision 1.13.2.1  2005/07/13 11:24:48  creckord
 * Fixed problem with objects of classes with same name but different packages
 *
 */
