/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.metamodel.*;


/**
 * Class GnuCPPGenVisitor
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.15 $
 */
public class GnuCPPClassGenVisitor
    extends AbstractCPPGenVisitor
{
   /**
    * Default Constructor
    */
   public GnuCPPClassGenVisitor()
   {
      super ("cc");
   }

   //
   // generate section
   //

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void generateClassEndBlock() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void generateClassStartBlock() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theFile  No description provided
    */
   public void generatePackageBegin (FFile theFile) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theFile  No description provided
    */
   public void generatePackageEnd (FFile theFile) { }

   //
   // create section
   //

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theCommentary  No description provided
    * @return               No description provided
    */
   public String createAttrCommentary (FCommentary theCommentary)
   {
      return EMPTY_STRING;
   }

   //
   // append section
   //

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param declString  No description provided
    */
   public void appendClassDeclaration (String declString) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comment  No description provided
    */
   public void appendAttrCommentary (String comment) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param declString  No description provided
    */
   public void appendAttrDeclaration (String declString) { }

   //
   // get identifier, keywords, literals etc.
   //

   /**
    * Get the uMLMethodDeclVisibilityString attribute of the GnuCPPClassGenVisitor object
    *
    * @param visibility  No description provided
    * @return            The uMLMethodDeclVisibilityString value
    */
   public String getMethodDeclVisibilityString (int visibility)
   {
      return null;
   }


   /**
    * Get the attrDeclName attribute of the GnuCPPClassGenVisitor object
    *
    * @param theAttr  No description provided
    * @return         The attrDeclName value
    */
   public String getAttrDeclName (FAttr theAttr)
   {
      return this.toString();
   }


   /**
    * Get the methodDeclName attribute of the GnuCPPClassGenVisitor object
    *
    * @param theMethod  No description provided
    * @return           The methodDeclName value
    */
   public String getMethodDeclName (FMethod theMethod)
   {
      StringBuffer declString = new StringBuffer();

      declString.append (theMethod.getFParent().getName());
      declString.append ("::");
      declString.append (theMethod.getName());

      return declString.toString();
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "GnuCPPClassGenVisitor[]";
   }
}

/*
 * $Log: GnuCPPClassGenVisitor.java,v $
 * Revision 1.15  2004/10/20 17:49:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
