/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * Class LinkCheckToManyOOFunction
 *
 * @author    $Author: l3_g5 $
 * @version   $Revision: 1.28.2.4 $
 */
public class LinkCheckToManyOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LinkCheckToManyOOFunction.class);


   /**
    * Default Constructor
    */
   public LinkCheckToManyOOFunction() { }


   /**
    * Get the responsible attribute of the LinkCheckToManyOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.LINK_CHECK_TO_MANY.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public Object generateCode (FElement incr,
                               String methodName,
                               Object param[])
   {
      UMLLink umlLink = (UMLLink) incr;
      UMLObject sourceObject;
      UMLObject targetObject;
      boolean targetBound;
      boolean sourceQualifierKey;
      boolean targetQualifierKey;
      String range;
      OOExpression[] umlAttrValuePairs;

      try
      {
         sourceObject = (UMLObject) param[0];
         targetObject = (UMLObject) param[1];
         targetBound =  ((Boolean) param[2]).booleanValue();
         sourceQualifierKey =  ((Boolean) param[3]).booleanValue();
         targetQualifierKey =  ((Boolean) param[4]).booleanValue();
         range = (String) param[5];
         umlAttrValuePairs = (OOExpression[]) param[6];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      String sourceObjectName = sourceObject.getObjectName();
      FType sourceObjectType = sourceObject.getInstanceOf();
      String sourceObjectTypeStr = sourceObject.getObjectType();
      String sourceRoleName = umlLink.getCorrespondingRole (targetObject).getAttrName();
      boolean sourceOptional = sourceObject.isOptional();
      boolean sourceSet = sourceObject.isSet();
      boolean sourceSetBound = sourceObject.isBound();

      String targetObjectName = targetObject.getObjectName();
      FType targetObjectType = targetObject.getInstanceOf();
      String targetObjectTypeStr = targetObject.getObjectType();
      String targetRoleName = umlLink.getCorrespondingRole (sourceObject).getAttrName();
      boolean targetOptional = targetObject.isOptional();
      boolean targetNegative = targetObject.isNegative();
      boolean targetSet = targetObject.isSet();

      boolean linkNegative = umlLink.getType() == UMLLink.NEGATIVE;

      if (log.isDebugEnabled())
      {
         log.debug (this + ".linkCheckToMany("
            + "sourceObjectName=" + sourceObjectName
            + ",sourceObjectType=" + sourceObjectType
            + ",sourceRoleName=" + sourceRoleName
            + ",sourceOptional=" + sourceOptional
            + ",sourceSet=" + sourceSet
            + ",sourceSetBound=" + sourceSetBound
            + ",targetObjectName=" + targetObjectName
            + ",targetObjectType=" + targetObjectType
            + ",targetRoleName=" + targetRoleName
            + ",targetOptional=" + targetOptional
            + ",targetNegative=" + targetNegative
            + ",targetBound=" + targetBound
            + ",targetSet=" + targetSet
            + ",sourceQualifierKey=" + sourceQualifierKey
            + ",targetQualifierKey=" + targetQualifierKey
            + ",range=" + range
            + ",linkNegative=" + linkNegative);
      }

      LinkedList statements = new LinkedList();

      StringBuffer comment = new StringBuffer();

      comment.append ("check To-Many-Link '");
      comment.append (sourceRoleName);
      comment.append ("' between ");
      comment.append (sourceObjectName);
      comment.append (" and ");
      comment.append (targetObjectName);

      OOStatement.add (statements, OO.lineComment (comment.toString()));
      OOExpression checkNegativeExpr = null;

      OOInfixExprLeft leftExpr = null;
      OOInfixExprLeft rightExpr = null;
      OOInfixExprLeft sourceNotNullExpr = null;

      OOCallMethodExpr methodExpr = null;
      OOCallMethodExpr hasInMethod = null;

      OOVariable sourceVar = null;
      if (sourceSet)
      {
         sourceVar = OO.variable (sourceObjectTypeStr, OOVariableType.iFujabaTmpObject);
      }
      else
      {
         sourceVar = OO.variable (sourceObjectName);
      }

      OOVariable targetVar = null;
      if (targetSet)
      {
         targetVar = OO.variable (targetObjectTypeStr, OOVariableType.iFujabaTmpObject);
      }
      else
      {
         targetVar = OO.variable (targetObjectName);
      }

      OOVariable uniqueName = OO.variable (CGU.upFirstChar (sourceVar.getFirstName()) + CGU.upFirstChar (sourceRoleName) +
         CGU.upFirstChar (targetObjectName),
         sourceVar.getType());

      String className = umlLink.getCorrespondingRole (targetObject).getTarget().getName();
      boolean typeCastNeeded = !targetObjectType.getName().equals (className) && !targetBound;
      boolean reverseQualifiedLink = !sourceQualifierKey && targetQualifierKey;
      boolean boundTargetSet = targetSet && targetBound;

      if (linkNegative ||  (targetNegative && !targetBound))
      {
         boolean ifStarted = false;

         // start Codegeneration for negative Node and Link
         if ( (!targetBound &&  ( (umlAttrValuePairs.length != 0) || typeCastNeeded || reverseQualifiedLink))
            || boundTargetSet)
         {
            // generate Code for Priority: P_CHECK_TO_MANY
            // optional
            if (sourceOptional && !sourceSet)
            {
               OOStatement.add (statements, OO.ifStat (OO.notNullExpr (sourceVar)));
               OOStatement.add (statements, OO.startBlock());
            }

            // ooops
            OOVariable uniqueIter = OO.variable (uniqueName.getFirstName(), OOVariableType.iFujabaIter);
            OOCallMethodExpr iteratorOfMethod = OO.call (sourceVar, OO.method (sourceRoleName, OOMethodType.ITERATOR_OF_METHOD));
            if (sourceQualifierKey)
            {
               iteratorOfMethod.addToParameter (OO.identifier (range));
            }
            OOStatement.add (statements, OO.varDecl ("FWIterator", uniqueIter, iteratorOfMethod));

            // while
            OOStatement.add (statements, OO.whileStat (OO.iterHasNext (uniqueIter, "<unknown>",
               OO.type (sourceRoleName), true)));
            OOStatement.add (statements, OO.startBlock());

            if (!typeCastNeeded)
            {
               OOLocalVarDeclStatement targetObjectVar = targetObjectType == null ?
                  OO.varDecl (targetObjectTypeStr, targetVar, OO.typeCast (targetObjectType, OO.iterGet (uniqueIter))) :
                  OO.varDecl (targetObjectType, targetVar, OO.typeCast (targetObjectType, OO.iterGet (uniqueIter)));

               OOStatement.add (statements, targetObjectVar);
               OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (uniqueIter)));
               OOStatement.add (statements, OO.emptyLine());
            }
            else
            { // typeCastNeeded
               OOStatement.add (statements, OO.varDecl (OO.type ("Object"), OO.variable (OOVariableType.iFujabaTmpObject), OO.iterGet (uniqueIter)));
               OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (uniqueIter)));
               OOStatement.add (statements, OO.emptyLine());

               if ( (umlAttrValuePairs.length != 0) || reverseQualifiedLink)
               {
                  OOStatement.add (statements, OO.ifStat (new OOObjectOfTypeExpr (OOVariable.FUJABA_TMP_OBJECT, targetObjectTypeStr)));
                  OOStatement.add (statements, OO.startBlock());

                  OOLocalVarDeclStatement targetObjectVar = targetObjectType == null ?
                     OO.varDecl (targetObjectTypeStr, targetVar, OO.typeCast (targetObjectType, OOVariable.FUJABA_TMP_OBJECT)) :
                     OO.varDecl (targetObjectType, targetVar, OO.typeCast (targetObjectType, OOVariable.FUJABA_TMP_OBJECT));

                  OOStatement.add (statements, targetObjectVar);
                  OOStatement.add (statements, OO.emptyLine());
                  ifStarted = true;
               }
            }

            if (umlAttrValuePairs.length != 0 && !targetBound)
            {
               // reverse qualified Link
               if (reverseQualifiedLink)
               {
                  hasInMethod = OO.call (targetVar, OO.method (targetRoleName, OOMethodType.HAS_IN_METHOD));
                  hasInMethod.addToParameter (OO.identifier (range));
                  hasInMethod.addToParameter (OO.identifier (sourceVar));
                  OOStatement.add (statements, OO.ifStat (hasInMethod));
                  OOStatement.add (statements, OO.startBlock());
               }

               OOInfixExprLeft attrExpr = null;
               for (int i = 0; i < umlAttrValuePairs.length; i++)
               {
                  if (attrExpr == null)
                  {
                     attrExpr = new OOInfixExprLeft (umlAttrValuePairs[i]);
                  }
                  else
                  {
                     attrExpr.append (OOInfixOp.AND_OP, umlAttrValuePairs[i]);
                  }
               }
               if (umlLink.isAssertInUnitTest() && targetBound && sourceSetBound)
               {
                  OOStatement.add (statements, OO.assertStmt (OO.not (attrExpr), comment.toString()));
               }
               else
               {
                  OOStatement.add (statements, OO.ensure (OO.not (attrExpr)));
               }

               if (reverseQualifiedLink)
               {
                  OOStatement.add (statements, OO.endBlock ("reverse qualified link end"));
               }

               if (ifStarted)
               {
                  OOStatement.add (statements, OO.endBlock());
               }
            }
            else
            {
               //  umlAttrValuePairs.length = 0 or bound-targetObject
               if (typeCastNeeded && !reverseQualifiedLink && !boundTargetSet)
               {
                  if (umlLink.isAssertInUnitTest() && targetBound && sourceSetBound)
                  {
                     OOStatement.add (statements, OO.assertStmt (OO.not (new OOObjectOfTypeExpr (OOVariable.FUJABA_TMP_OBJECT,
                        targetObjectTypeStr)), comment.toString()));
                  }
                  else
                  {
                     OOStatement.add (statements, OO.ensure (OO.not (new OOObjectOfTypeExpr (OOVariable.FUJABA_TMP_OBJECT,
                        targetObjectTypeStr))));
                  }
               }
               else if (reverseQualifiedLink && !boundTargetSet)
               {
                  // reverse qualified Link
                  hasInMethod = OO.call (targetVar, OO.method (targetRoleName, OOMethodType.HAS_IN_METHOD));
                  hasInMethod.addToParameter (OO.identifier (range));
                  hasInMethod.addToParameter (OO.identifier (sourceVar));
                  if (umlLink.isAssertInUnitTest() && targetBound && sourceSetBound)
                  {
                     OOStatement.add (statements, OO.assertStmt (OO.not (hasInMethod), comment.toString()));
                  }
                  else
                  {
                     OOStatement.add (statements, OO.ensure (OO.not (hasInMethod)));
                  }
               }
               else if (boundTargetSet && !reverseQualifiedLink)
               {
                  // bound TargetSet
                  if (umlLink.isAssertInUnitTest() && targetBound && sourceSetBound)
                  {
                     OOStatement.add (statements, OO.assertStmt (OO.call (targetObjectName,
                        OOMethod.SET_CONTAINS_METHOD, OO.identifier (targetVar)), comment.toString()));
                  }
                  else
                  {
                     OOStatement.add (statements, OO.ensure (OO.call (targetObjectName,
                        OOMethod.SET_CONTAINS_METHOD, OO.identifier (targetVar))));
                  }
               }
               else if (boundTargetSet && reverseQualifiedLink)
               {
                  OOStatement.add (statements, OO.ifStat (OO.call (targetObjectName,
                     OOMethod.SET_CONTAINS_METHOD,
                     OO.identifier (targetVar))));
                  OOStatement.add (statements, OO.startBlock());

                  // check reverse qualified Link
                  hasInMethod = OO.call (targetVar,
                     OO.method (targetRoleName,
                     OOMethodType.HAS_IN_METHOD));
                  hasInMethod.addToParameter (OO.identifier (range));
                  hasInMethod.addToParameter (OO.identifier (sourceVar));
                  if (umlLink.isAssertInUnitTest() && targetBound && sourceSetBound)
                  {
                     OOStatement.add (statements, OO.assertStmt (OO.not (hasInMethod), comment.toString()));
                  }
                  else
                  {
                     OOStatement.add (statements, OO.ensure (OO.not (hasInMethod)));
                  }

                  OOStatement.add (statements, OO.endBlock ("boundTargetSet && reverseQualifiedLink"));
               }
               else
               {
                  log.error ("Error in linkCheckToMany (..) for negative Node or Link");
               }

               if (ifStarted)
               {
                  OOStatement.add (statements, OO.endBlock());
               }
            }

            // while
            OOStatement.add (statements, OO.endBlock ("while"));

            // optional
            if (sourceOptional && !sourceSet)
            {
               OOStatement.add (statements, OO.endBlock ("optional"));
            }

         }
         else
         {
            // generate Code for Priority: P_CHECK with negative Node or Link
            // source optional
            if (sourceOptional && !sourceSet)
            {
               sourceNotNullExpr = OO.isNullExpr (sourceVar);
            }

            OOVariable methodObjectVar =  (!reverseQualifiedLink ? sourceVar : targetVar);

            if ( (targetNegative && !targetBound && !sourceQualifierKey) ||  (linkNegative && !targetBound && !sourceQualifierKey))
            {
               methodExpr = OO.call (methodObjectVar, OO.method (sourceRoleName, OOMethodType.SIZE_OF_METHOD));
               checkNegativeExpr = OO.infixOp (methodExpr, OOInfixOp.EQUAL_OP, OO.variable ("0"));
            }
            else
            {
               if (targetBound)
               {
                  if (!reverseQualifiedLink)
                  {
                     methodExpr = OO.call (methodObjectVar, OO.method (sourceRoleName, OOMethodType.HAS_IN_METHOD));

                     if (sourceQualifierKey)
                     {
                        methodExpr.addToParameter (OO.identifier (range));
                     }

                     methodExpr.addToParameter (OO.identifier (targetVar));
                  }
                  else
                  {
                     // reverseQualifiedLink
                     methodExpr = OO.call (methodObjectVar, OO.method (targetRoleName, OOMethodType.HAS_IN_METHOD));
                     methodExpr.addToParameter (OO.identifier (range));
                     methodExpr.addToParameter (OO.identifier (sourceVar));
                  }
               }
               else
               {
                  methodExpr = OO.call (methodObjectVar,
                     OO.method (sourceRoleName,
                     OOMethodType.HAS_KEY_IN_METHOD),
                     OO.identifier (range));
               }
               checkNegativeExpr = methodExpr;
            }

            OOExpression conditionExpr = null;
            if (sourceNotNullExpr != null)
            {
               conditionExpr = OO.infixOp (sourceNotNullExpr, OOInfixOp.OR_OP, checkNegativeExpr);
            }
            else
            {
               conditionExpr = checkNegativeExpr;
            }

            if (umlLink.isAssertInUnitTest() && targetBound && sourceSetBound)
            {
               OOStatement.add (statements, OO.assertStmt (conditionExpr, comment.toString()));
            }
            else if (linkNegative)
            {
               OOStatement.add (statements, OO.ensure (OO.not (conditionExpr)));
            }
            else
            {
               OOStatement.add (statements, OO.ensure (conditionExpr));
            }
         } // end Codegeneration for negative Link and Node
      }
      else
      {
         // no negative Link or Node
         if (sourceOptional && targetOptional)
         {
            leftExpr = OO.infixOp (OO.isNullExpr (sourceVar),
               OOInfixOp.OR_OP,
               OO.isNullExpr (targetVar));
            rightExpr = OO.infixOp (OO.notNullExpr (sourceVar),
               OOInfixOp.OR_OP,
               OO.notNullExpr (targetVar));
         }
         else
         {
            if (targetOptional && umlLink.getType() == UMLLink.OPTIONAL)
            {
               rightExpr = OO.isNullExpr (targetVar);
            }

            if (sourceOptional)
            {
               rightExpr = OO.isNullExpr (sourceVar);
            }
         }

         methodExpr = OO.call (sourceVar,
            OO.method (sourceRoleName,
            OOMethodType.HAS_IN_METHOD));

         if (sourceQualifierKey)
         {
            methodExpr.addToParameter (OO.identifier (range));
         }

         methodExpr.addToParameter (OO.identifier (targetVar));

         OOExpression conditionExpr = null;
         if (rightExpr != null)
         {
            rightExpr.append (OOInfixOp.OR_OP, methodExpr);
            conditionExpr = rightExpr;
         }
         else
         {
            conditionExpr = methodExpr;
         }

         if (sourceOptional && targetOptional)
         {
            conditionExpr = OO.infixOp (leftExpr,
               OOInfixOp.OR_OP,
               conditionExpr);
         }

         if (umlLink.isAssertInUnitTest() && targetBound && sourceSetBound)
         {
            OOStatement.add (statements, OO.assertStmt (conditionExpr, comment.toString()));
         }
         else
         {
            OOStatement.add (statements, OO.ensure (conditionExpr));
         }
      }

      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "LinkCheckToManyOOFunction[]";
   }
}

/*
 * $Log: LinkCheckToManyOOFunction.java,v $
 * Revision 1.28.2.4  2006/04/06 09:45:43  l3_g5
 * bugfix for optional objects
 *
 */
