/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLLink;


/**
 * Class LinkCheckToOneOOFunction
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.23.2.3 $
 */
public class LinkCheckToOneOOFunction
    extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LinkCheckToOneOOFunction.class);


   /**
    * Default Constructor
    */
   public LinkCheckToOneOOFunction() { }


   /**
    * Get the responsible attribute of the LinkCheckToOneOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.LINK_CHECK_TO_ONE.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public Object generateCode (FElement incr,
                               String methodName,
                               Object param[])
   {
      UMLLink link = (UMLLink) incr;
      String sourceObjectName;
      String sourceObjectType;
      String sourceRoleName;
      boolean sourceOptional;
      boolean sourceSet;
      boolean sourceSetBound;
      String targetObjectName;
      FType targetObjectType;
      String targetObjectTypeStr;
      String targetRoleName;
      boolean targetOptional;
      boolean targetNegative;
      boolean targetBound;
      boolean sourceQualifierKey;
      boolean targetQualifierKey;
      String range;
      String className;
      boolean linkNegative;
      boolean linkOptional;
      OOExpression[] umlAttrValuePairs;

      try
      {
         sourceObjectName = (String) param[0];
         sourceObjectType = (String) param[1];
         sourceRoleName = (String) param[2];
         sourceOptional =  ((Boolean) param[3]).booleanValue();
         sourceSet =  ((Boolean) param[4]).booleanValue();
         sourceSetBound =  ((Boolean) param[5]).booleanValue();
         targetObjectName = (String) param[6];
         targetObjectType = (FType) param[7];
         targetObjectTypeStr = (String) param[8];
         targetRoleName = (String) param[9];
         targetOptional =  ((Boolean) param[10]).booleanValue();
         targetNegative =  ((Boolean) param[11]).booleanValue();
         targetBound =  ((Boolean) param[12]).booleanValue();
         sourceQualifierKey =  ((Boolean) param[13]).booleanValue();
         targetQualifierKey =  ((Boolean) param[14]).booleanValue();
         range = (String) param[15];
         className = (String) param[16];
         linkNegative =  ((Boolean) param[17]).booleanValue();
         linkOptional =  ((Boolean) param[18]).booleanValue();
         umlAttrValuePairs = (OOExpression[]) param[19];
      }
      catch (Exception exception)
      {
         exception.printStackTrace();
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".linkCheckToOne("
            + "sourceObjectName=" + sourceObjectName
            + ",sourceObjectType=" + sourceObjectType
            + ",sourceRoleName=" + sourceRoleName
            + ",sourceOptional=" + sourceOptional
            + ",sourceSet=" + sourceSet
            + ",sourceSetBound=" + sourceSetBound
            + ",targetObjectName=" + targetObjectName
            + ",targetObjectType=" + targetObjectType
            + ",targetRoleName=" + targetRoleName
            + ",targetOptional=" + targetOptional
            + ",targetNegative=" + targetNegative
            + ",targetBound=" + targetBound
            + ",sourceQualifierKey=" + sourceQualifierKey
            + ",targetQualifierKey=" + targetQualifierKey
            + ",range=" + range
            + ",className=" + className
            + ",linkNegative=" + linkNegative
            + ",linkOptional=" + linkOptional
            );
      }

      LinkedList statements = new LinkedList();

      StringBuffer comment = new StringBuffer();
      comment.append ("check To-One-Link '");
      comment.append (sourceRoleName);
      comment.append ("' between ");
      comment.append (sourceObjectName);
      comment.append (" and ");
      comment.append (targetObjectName);

      OOStatement.add (statements, OO.lineComment (comment.toString()));

      OOVariable varName = null;
      OOVariable iterName = OO.variable (sourceObjectName, OOVariableType.iFujabaIter);

      OOMethod accessMethodName = null;
      OOCallMethodExpr conditionMethodExpr = null;
      OOCallMethodExpr methodExpr = null;

      OOInfixExprLeft attrExpr = null;
      OOInfixExprLeft innerVarNameExpr = null;

      OOExpression conditionExpr = null;
      OOExpression sourceOptionalExpr = null;
      OOExpression targetOptionalExpr = null;
      OOExpression varNameExpr = null;
      OOExpression nextVarNameExpr = null;
      OOExpression accessMethodParameter = null;

      if (sourceSet)
      {
         varName = OO.variable (sourceObjectType, OOVariableType.iFujabaTmpObject);
      }
      else
      {
         varName = OO.variable (sourceObjectName);
      }

      if (sourceQualifierKey)
      {
         accessMethodName = OO.method (sourceRoleName, OOMethodType.GET_FROM_METHOD);
         accessMethodParameter = OO.identifier (range);
      }
      else
      {
         accessMethodName = OO.method (sourceRoleName, OOMethodType.GET_METHOD);
      }

      boolean typeCastNeeded = !targetObjectType.getName().equals (className) && !targetBound;
      boolean reversedQualifiedLink = !sourceQualifierKey && targetQualifierKey;
      boolean qualifiedLink = sourceQualifierKey || targetQualifierKey;
      if (log.isDebugEnabled())
      {
         if (log.isInfoEnabled())
         {
            log.info ("[JavaFactory.linkCheckToOne()] ");
         }
      }

      if (linkNegative ||  (targetNegative && !targetBound))
      {
         // Start-Wrapper for generated Code if Sourceobject is a Set
         if (sourceSet)
         {
            OOStatement.add (statements, OO.assignStat (iterName,
               OO.iterOf (sourceObjectName)));

            OOStatement.add (statements, OO.whileStat (OO.iterHasNext (iterName, sourceObjectName)));
            OOStatement.add (statements, OO.startBlock());

            if (!sourceSetBound)
            {
               OOStatement.add (statements, new OOTryStatement());
               OOStatement.add (statements, OO.startBlock());
            }
         }

         if (!targetBound &&  ( (umlAttrValuePairs.length != 0) || typeCastNeeded || reversedQualifiedLink))
         {
            // if
            conditionExpr = OO.notNullExpr (OO.call (varName, accessMethodName,
               accessMethodParameter));

            if (sourceOptional && !sourceSet)
            {
               sourceOptionalExpr = OO.notNullExpr (varName);

               conditionExpr = OO.infixOp (sourceOptionalExpr,
                  OOInfixOp.AND_OP,
                  conditionExpr);
            }

            OOStatement.add (statements, OO.ifStat (conditionExpr));
            OOStatement.add (statements, OO.startBlock());

            if (!typeCastNeeded)
            {
               OOLocalVarDeclStatement targetObjectVar =
                  targetObjectType == null ?
                  OO.varDecl (targetObjectTypeStr, targetObjectName,
                  OO.call (varName, accessMethodName, accessMethodParameter)) :
                  OO.varDecl (targetObjectType, targetObjectName,
                  OO.call (varName, accessMethodName, accessMethodParameter));
               OOStatement.add (statements, targetObjectVar);
            }
            else
            { // typecast needed

               OOStatement.add (statements, OO.varDecl (OO.type ("Object"), OO.variable (OOVariableType.iFujabaTmpObject),
                  OO.call (varName, accessMethodName, accessMethodParameter)));

               if ( (umlAttrValuePairs.length != 0) || reversedQualifiedLink)
               {
                  OOStatement.add (statements, OO.ifStat (new OOObjectOfTypeExpr (OOVariableType.iFujabaTmpObject,
                     targetObjectTypeStr)));
                  OOStatement.add (statements, OO.startBlock());

                  OOStatement.add (statements, OO.assignStat (targetObjectName,
                     OO.typeCast (targetObjectType,
                     OOVariableType.iFujabaTmpObject)));
                  OOStatement.add (statements, OO.emptyLine());
               }
            }

            if (umlAttrValuePairs.length != 0)
            {
               if (reversedQualifiedLink)
               {
                  conditionMethodExpr = OO.call (targetObjectName,
                     OO.method (targetRoleName, OOMethodType.HAS_IN_METHOD));
                  conditionMethodExpr.addToParameter (OO.identifier (range));
                  conditionMethodExpr.addToParameter (OO.identifier (sourceObjectName));

                  OOStatement.add (statements, OO.ifStat (conditionMethodExpr));

               }

               // generate attribute-constraints
               attrExpr = null;
               for (int i = 0; i < umlAttrValuePairs.length; i++)
               {
                  if (attrExpr == null)
                  {
                     attrExpr = new OOInfixExprLeft (umlAttrValuePairs[i]);
                  }
                  else
                  {
                     attrExpr.append (OOInfixOp.AND_OP, umlAttrValuePairs[i]);
                  }
               }
               if (link.isAssertInUnitTest() && targetBound && sourceSetBound)
               {
                  OOStatement.add (statements, OO.assertStmt (OO.not (attrExpr), comment.toString()));
               }
               else
               {
                  OOStatement.add (statements, OO.ensure (OO.not (attrExpr)));
               }

               if (reversedQualifiedLink)
               {
                  OOStatement.add (statements, OO.endBlock());
               }

               if (typeCastNeeded)
               {
                  OOStatement.add (statements, OO.endBlock());
               }
            }
            else
            { // umlAttrValuePairs.length = 0

               if (!reversedQualifiedLink)
               {
                  if (typeCastNeeded)
                  {
                     if (link.isAssertInUnitTest() && targetBound && sourceSetBound)
                     {
                        OOStatement.add (statements, OO.assertStmt (OO.not (OO.typeCast
                            (targetObjectType, OOVariableType.iFujabaTmpObject)), comment.toString()));
                     }
                     else
                     {
                        OOStatement.add (statements, OO.ensure (OO.not (new OOObjectOfTypeExpr
                            (OOVariableType.iFujabaTmpObject, targetObjectTypeStr))));
                     }
                     OOStatement.add (statements, OO.emptyLine());
                  }
               }
               else
               { // reversedQualifiedLink

                  methodExpr = OO.call (targetObjectName,
                     OO.method (targetRoleName, OOMethodType.HAS_IN_METHOD));
                  methodExpr.addToParameter (OO.identifier (range));
                  methodExpr.addToParameter (OO.identifier (sourceObjectName));
                  if (link.isAssertInUnitTest() && targetBound && sourceSetBound)
                  {
                     OOStatement.add (statements, OO.assertStmt (OO.not (methodExpr), comment.toString()));
                  }
                  else
                  {
                     OOStatement.add (statements, OO.ensure (OO.not (methodExpr)));
                  }
               }
            }

            // if
            OOStatement.add (statements, OO.endBlock());
         }
         else
         { // genearate single SDMEnsure() method

            if (sourceOptional && !sourceSet)
            {
               sourceOptionalExpr = OO.isNullExpr (varName);
            }

            if (targetBound)
            {
               if (!qualifiedLink)
               {
                  varNameExpr = OO.isNullExpr (varName);
                  OOExpression resultNotNullExpr = OO.isNullExpr (OO.call (varName,
                     accessMethodName,
                     accessMethodParameter));
                  methodExpr = OO.call (varName,
                     accessMethodName,
                     accessMethodParameter).append (OOMethodType.EQUALS_METHOD,
                     targetObjectName);
                  varNameExpr = OO.infixOp (varNameExpr, OOInfixOp.OR_OP, OO.infixOp (resultNotNullExpr, OOInfixOp.OR_OP, OO.not (methodExpr)));

               }
               else
               { // qualified Link

                  if (!reversedQualifiedLink)
                  {
                     methodExpr = OO.call (varName, OO.method (sourceRoleName, OOMethodType.HAS_IN_METHOD));
                     methodExpr.addToParameter (OO.identifier (range));
                     methodExpr.addToParameter (OO.identifier (targetObjectName));

                     varNameExpr = OO.not (methodExpr);

                  }
                  else
                  { // reversed qualified Link

                     methodExpr = OO.call (varName, OO.method (targetRoleName, OOMethodType.HAS_IN_METHOD));
                     methodExpr.addToParameter (OO.identifier (range));
                     methodExpr.addToParameter (OO.identifier (sourceObjectName));

                     varNameExpr = OO.not (methodExpr);
                  }
               }

               if (sourceOptionalExpr != null)
               {
                  varNameExpr = OO.infixOp (sourceOptionalExpr, OOInfixOp.OR_OP, varNameExpr);
               }
            }
            else
            { // target not bound

               if (targetOptional || linkOptional)
               {
                  targetOptionalExpr = OO.isNullExpr (targetObjectName);
               }

               if (!qualifiedLink)
               {
                  varNameExpr = OO.isNullExpr (OO.call (varName, accessMethodName, accessMethodParameter));
               }
               else
               {
                  methodExpr = OO.call (varName, accessMethodName, accessMethodParameter);
                  methodExpr.addToParameter (OO.identifier (range));
                  methodExpr.addToParameter (OO.identifier (sourceObjectName));

                  varNameExpr = OO.not (methodExpr);
               }
               if (targetOptionalExpr != null)
               {
                  varNameExpr = OO.infixOp (targetOptionalExpr, OOInfixOp.OR_OP, varNameExpr);
               }
            }

            // append SDM statement
            if (link.isAssertInUnitTest() && targetBound && sourceSetBound)
            {
               OOStatement.add (statements, OO.assertStmt (varNameExpr, comment.toString()));
            }
            else
            {
               OOStatement.add (statements, OO.ensure (varNameExpr));
            }
         }

         // End-Wrapper for generated Code if Sourceobject is a Set
         if (sourceSet)
         {
            if (!sourceSetBound)
            {
               // try-Block
               OOStatement.add (statements, OO.endBlock());

               // catch-Block
               OOStatement.add (statements, OO.catchStat (OOExceptionExpr.SDM_EXCEPTION,
                  OO.variable (OOVariableType.iBreakExceptionVariable)));
               OOStatement.add (statements, OO.startBlock());
               OOStatement.add (statements, OO.callStat (OO.variable (sourceObjectName,
                  OOVariableType.iFujabaEnum),
                  OO.method ("remove")));
               OOStatement.add (statements, OO.endBlock());
            }

            OOStatement.add (statements, OO.endBlock());
            OOStatement.add (statements, OO.emptyLine());
         }

      }
      else
      { // no negative Link or Node

         if (sourceOptional && targetOptional)
         {
            varNameExpr = OO.infixOp (OO.isNullExpr (varName),
               OOInfixOp.OR_OP,
               OO.isNullExpr (targetObjectName));
            innerVarNameExpr = OO.infixOp (OO.notNullExpr (varName),
               OOInfixOp.AND_OP,
               OO.notNullExpr (targetObjectName));
         }
         else
         {
            if (sourceOptional)
            {
               varNameExpr = OO.notNullExpr (varName);
            }

            if (targetOptional || linkOptional)
            {
               innerVarNameExpr = OO.notNullExpr (targetObjectName);
               if (sourceOptional)
               {
                  varNameExpr = OO.infixOp (varNameExpr,
                     OOInfixOp.OR_OP,
                     innerVarNameExpr);
               }
               else
               {
                  varNameExpr = innerVarNameExpr;
               }
            }
         }

         nextVarNameExpr = OO.infixOp (OO.notNullExpr (OO.call (varName,
            accessMethodName,
            accessMethodParameter)),
            OOInfixOp.AND_OP,
            OO.call (varName,
            accessMethodName,
            accessMethodParameter).append (OOMethodType.EQUALS_METHOD,
            targetObjectName));

         if (innerVarNameExpr != null && varNameExpr != null)
         {
            innerVarNameExpr.append (OOInfixOp.AND_OP, nextVarNameExpr);

            conditionExpr = OO.infixOp (varNameExpr,
               OOInfixOp.OR_OP,
               innerVarNameExpr);
         }
         else if (varNameExpr != null)
         {
            conditionExpr = OO.infixOp (varNameExpr,
               OOInfixOp.OR_OP,
               nextVarNameExpr);
         }
         else
         {
            conditionExpr = nextVarNameExpr;
         }

         if (link.isAssertInUnitTest() && targetBound && sourceSetBound)
         {
            OOStatement.add (statements, OO.assertStmt (conditionExpr, comment.toString()));
         }
         else
         {
            OOStatement.add (statements, OO.ensure (conditionExpr));
         }
      }

      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "LinkCheckToOneOOFunction[]";
   }
}

/*
 * $Log: LinkCheckToOneOOFunction.java,v $
 * Revision 1.23.2.3  2005/09/30 18:56:55  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
