/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * Class LinkCheckToSetOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14.2.1 $
 */
public class LinkCheckToSetOOFunction
    extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LinkCheckToSetOOFunction.class);


   /**
    * Default Constructor
    */
   public LinkCheckToSetOOFunction() { }


   /**
    * Get the responsible attribute of the LinkCheckToSetOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.LINK_CHECK_TO_SET.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String linkName;
      boolean toOne;
      String sourceObjectName;
      String sourceObjectType;
      String targetObjectName;
      String targetObjectType;
      boolean isTargetSet;
      boolean linkNegative;
      boolean toNegative;

      try
      {
         linkName = (String) param[0];
         toOne =  ((Boolean) param[1]).booleanValue();
         sourceObjectName = (String) param[2];
         sourceObjectType = (String) param[3];
         targetObjectName = (String) param[4];
         targetObjectType = (String) param[5];
         isTargetSet =  ((Boolean) param[6]).booleanValue();
         linkNegative =  ((Boolean) param[7]).booleanValue();
         toNegative =  ((Boolean) param[8]).booleanValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".linkCheckToSet("
            + "linkName=" + linkName
            + "toOne=" + toOne
            + ",sourceObjectName=" + sourceObjectName
            + ",sourceObjectType=" + sourceObjectType
            + ",targetObjectName=" + targetObjectName
            + ",targetObjectType=" + targetObjectType
            + ",isTargetSet=" + isTargetSet
            + ",linkNegative=" + linkNegative
            + ",toNegative=" + toNegative
            );
      }

      LinkedList statements = new LinkedList();

      StringBuffer comment = new StringBuffer();

      comment.append (" check link :) '");
      comment.append (linkName);
      comment.append ("' between ");
      comment.append (sourceObjectName);
      comment.append (" and ");
      comment.append (targetObjectName);

      OOStatement.add (statements, OO.lineComment (comment.toString()));

      OOInfixOp infixOp = null;
      OOExpression conditionExpr = null;
      OOExpression leftExpr = null;

      String setType;
      if (isTargetSet)
      {
         setType = targetObjectType;
      }
      else
      {
         setType = sourceObjectType;
      }

      OOVariable tmpObjectName = OO.variable (setType, OOVariableType.iFujabaTmpObject);

      OOVariable sourceName;
      OOIdentifierExpr targetName;
      if (isTargetSet)
      {
         sourceName = OO.variable (sourceObjectName);
         targetName = OO.identifier (tmpObjectName);
      }
      else
      {
         sourceName = tmpObjectName;
         targetName = OO.identifier (targetObjectName);
      }

      if (toOne)
      {
         leftExpr = OO.call (sourceName,
            OO.method (linkName, OOMethodType.GET_METHOD));
         if (linkNegative)
         {
            infixOp = OOInfixOp.NOT_EQUAL_OP;
         }
         else
         {
            infixOp = OOInfixOp.EQUAL_OP;
         }

         conditionExpr = OO.infixOp (leftExpr, infixOp, targetName);
      } // end of if ()

      else
      {
         conditionExpr = OO.call (sourceName,
            OO.method (linkName, OOMethodType.HAS_IN_METHOD), targetName);
         if (linkNegative)
         {
            conditionExpr = OO.not (conditionExpr);
         }
      } // end of else

      OOStatement.add (statements, OO.ensure (conditionExpr));
      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "LinkCheckToSetOOFunction[]";
   }
}

/*
 * $Log: LinkCheckToSetOOFunction.java,v $
 * Revision 1.14.2.1  2005/08/23 08:24:41  lowende
 * Removed compile warnings.
 *
 */
