/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;


/**
 * Class LinkCreateSetOOFunction
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.2.2.1 $
 */
public class LinkCreateSetTopOOFunction
    extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LinkCreateSetOOFunction.class);


   /**
    * Default Constructor
    */
   public LinkCreateSetTopOOFunction() { }


   /**
    * Get the responsible attribute of the LinkCreateSetOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.LINK_CREATE_SET_TOP.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String objectName;
      FType objectType;
      String objectTypeStr;

      // parse param
      try
      {
         objectName = (String) param[0];
         objectType = (FType) param[1];
         objectTypeStr = (String) param[2];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".linkDeleteSet("
            + "objectName=" + objectName
            + "objectType=" + objectType
            );
      }

      LinkedList statements = new LinkedList();

      String iterString = CGU.upFirstChar (objectName);
      OOVariable iterName = OO.variable (iterString, OOVariableType.iFujabaIter);
      OOVariable setTmpObject = OO.variable (objectTypeStr, OOVariableType.iFujabaTmpObject);

      OOStatement.add (statements, OO.varDecl ("FWIterator",
         iterName, OO.iterOf (objectName)));

      OOStatement.add (statements, OO.whileStat (OO.iterHasNext (iterName, objectName)));
      OOStatement.add (statements, OO.startBlock());

      OOLocalVarDeclStatement objectVar = objectType == null ?
         OO.varDecl (objectTypeStr,
         setTmpObject, OO.typeCast (objectType, OO.iterGet (iterName))) :
         OO.varDecl (objectType,
         setTmpObject, OO.typeCast (objectType, OO.iterGet (iterName)));
      OOStatement.add (statements, objectVar);
      OOStatement.add (statements, OO.exprStat (OO.iterGotoNext (iterName)));

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "LinkCreateSetTopOOFunction[]";
   }
}

/*
 * $Log: LinkCreateSetTopOOFunction.java,v $
 * Revision 1.2.2.1  2005/07/13 11:24:50  creckord
 * Fixed problem with objects of classes with same name but different packages
 *
 */
