/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * Class LinkDeleteOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.13 $
 */
public class LinkDeleteOOFunction
    extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LinkDeleteOOFunction.class);


   /**
    * Default Constructor
    */
   public LinkDeleteOOFunction() { }


   /**
    * Get the responsible attribute of the LinkDeleteOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.LINK_DELETE.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public Object generateCode (FElement incr,
                               String methodName,
                               Object param[])
   {
      String linkName;
      boolean toOne;
      String sourceName;
      boolean sourceOptional;
      String targetName;
      boolean targetOptional;

      // parse param
      try
      {
         linkName = (String) param[0];
         toOne =  ((Boolean) param[1]).booleanValue();
         sourceName = (String) param[2];
         sourceOptional =  ((Boolean) param[3]).booleanValue();
         targetName = (String) param[4];
         targetOptional =  ((Boolean) param[5]).booleanValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".linkDelete("
            + "linkName=" + linkName
            + ",toOne=" + toOne
            + ",sourceName=" + sourceName
            + ",sourceOptional=" + sourceOptional
            + ",targetName=" + targetName
            + ",targetOptional=" + targetOptional
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" delete link"));

      OOMethod accessMethod = null;
      OOVariable objectName = null;
      OOInfixExprLeft sourceExpr = null;
      OOInfixExprLeft targetExpr = null;
      OOCallMethodExpr methodExpr = null;

      if (sourceOptional || targetOptional)
      {
         if (sourceOptional)
         {
            sourceExpr = OO.notNullExpr (sourceName);
         }
         if (targetOptional)
         {
            targetExpr = OO.notNullExpr (targetName);
            if (sourceExpr != null)
            {
               sourceExpr = OO.infixOp (sourceExpr, OOInfixOp.AND_OP, targetExpr);
            }
            else
            {
               sourceExpr = targetExpr;
            }
         }

         OOStatement.add (statements, OO.ifStat (sourceExpr));
         OOStatement.add (statements, OO.startBlock());
      }

      accessMethod =  (toOne) ? OO.method (linkName, OOMethodType.SET_METHOD) :
         OO.method (linkName, OOMethodType.REMOVE_METHOD);

      objectName = OO.variable (sourceName);
      methodExpr = OO.call (objectName, accessMethod);

      if (toOne)
      {
         methodExpr.addToParameter (OOIdentifierExpr.NULL_IDENTIFIER);
      }
      else
      {
         methodExpr.addToParameter (OO.identifier (targetName));
      }

      OOStatement.add (statements, OO.exprStat (methodExpr));

      if (sourceOptional || targetOptional)
      {
         OOStatement.add (statements, OO.endBlock());
      }

      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "LinkDeleteOOFunction[]";
   }
}

/*
 * $Log: LinkDeleteOOFunction.java,v $
 * Revision 1.13  2005/03/07 11:45:35  lowende
 * Patch for new assoc generation plugin:
 * some final methods set to non-final.
 *
 */
