/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * Class LinkSearchToManyBottomOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.26 $
 */
public class LinkSearchToManyBottomOOFunction
    extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LinkSearchToManyBottomOOFunction.class);


   /**
    * Default Constructor
    */
   public LinkSearchToManyBottomOOFunction() { }


   /**
    * Get the responsible attribute of the LinkSearchToManyBottomOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.LINK_SEARCH_TO_MANY_BOTTOM.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String sourceObjectName;
      String linkName;
      String targetObjectName;
      boolean targetOptional;
      boolean targetSet;
      boolean forEach;

      // parse param
      try
      {
         sourceObjectName = (String) param[0];
         linkName = (String) param[1];
         targetObjectName = (String) param[2];
         targetOptional =  ((Boolean) param[3]).booleanValue();
         targetSet =  ((Boolean) param[4]).booleanValue();
         forEach =  ((Boolean) param[5]).booleanValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".linkSearchToManyBottom("
            + "sourceObjectName=" + sourceObjectName
            + ",linkName=" + linkName
            + ",targetObjectName=" + targetObjectName
            + ",targetOptional=" + targetOptional
            + ",targetSet=" + targetSet
            + ",forEach=" + forEach
            );
      }

      LinkedList statements = new LinkedList();

      if (!targetSet)
      {
         OOStatement.add (statements, OO.endBlock());
         OOStatement.add (statements, OO.catchStat (OOExceptionExpr.SDM_EXCEPTION,
            OO.variable (OOVariableType.iBreakExceptionVariable)));
         OOStatement.add (statements, OO.startBlock());
         OOStatement.add (statements, OO.endBlock());

         if (targetOptional)
         {
            OOExpression whileCondition = null;
            if (!forEach)
            {
               whileCondition = OO.not (OO.variable (OOVariableType.iFujabaSuccess));
            }
            else
            {
               StringBuffer uniqueName = new StringBuffer (CGU.upFirstChar (sourceObjectName));
               uniqueName.append (CGU.upFirstChar (linkName));
               uniqueName.append (CGU.upFirstChar (targetObjectName));

               OOVariable iterName = OO.variable (uniqueName.toString(), OOVariableType.iFujabaIter);
               whileCondition = OO.iterHasNext (iterName, sourceObjectName);
            }
            OOStatement.add (statements, OO.endBlock());
            OOStatement.add (statements, OO.whileStat (whileCondition, true));
         }
         else
         {
            OOStatement.add (statements, OO.endBlock());
         }
      }

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "LinkSearchToManyBottomOOFunction[]";
   }
}

/*
 * $Log: LinkSearchToManyBottomOOFunction.java,v $
 * Revision 1.26  2005/02/01 21:21:10  lowende
 * Some optimizations.
 *
 */
