/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLMultiLink;


/**
 * Class MultiLinkCheckLastOOFunction
 *
 * @author    $Author: l3_g5 $
 * @version   $Revision: 1.16.2.1 $
 */
public class MultiLinkCheckLastOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (MultiLinkCheckLastOOFunction.class);


   /**
    * Default Constructor
    */
   public MultiLinkCheckLastOOFunction() { }


   /**
    * Get the responsible attribute of the MultiLinkCheckLastOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.MULTILINK_CHECK_LAST.equals (methodName);
   }


   /**
    * for bound objects with last multilink Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      UMLMultiLink link = (UMLMultiLink) incr;
      String objectName;
      String objectType;
      String containerObjectName;
      String containerName;

      try
      {
         objectName = (String) param[0];
         objectType = (String) param[1];
         containerObjectName = (String) param[2];
         containerName = (String) param[3];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".multiLinkCheckLast("
            + "objectName=" + objectName
            + ",objectType=" + objectType
            + ",containerObjectName=" + containerObjectName
            + ",containerName=" + containerName
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" check multiLink " + objectName +
         " : " + objectType));

      /*
       *  result.append (newLine ()).append ("JavaSDM.ensure (").append (containerObjectName).append (".").append ("getLastOf");
       *  result.append (CGU.upFirstChar (containerName)).append ("().equals (").append (objectName).append ("));\n\n");
       *  return result.toString ();
       */
      OOCallMethodExpr ensureMethod = null;

      ensureMethod = OO.call (containerObjectName, OO.method (containerName,
         OOMethodType.GET_LAST_OF_METHOD));
      ensureMethod = OO.call (objectName, OOMethod.EQUALS_METHOD, ensureMethod);
      if (link.isAssertInUnitTest())
      {
         OOStatement.add (statements, OO.assertStmt (ensureMethod, "check multiLink " + objectName +
            " : " + objectType));
      }
      else
      {
         OOStatement.add (statements, OO.ensure (ensureMethod));
      }

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "MultiLinkCheckLastOOFunction[]";
   }
}

/*
 * $Log: MultiLinkCheckLastOOFunction.java,v $
 * Revision 1.16.2.1  2005/11/18 10:57:49  l3_g5
 * attribute assertions for multilinks work
 *
 */
