/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Enumeration;
import java.util.NoSuchElementException;


/**
 * A OOGenTokenIterator is a Enumeration that is also able to traverse a token list backwards.
 * Use the prevElement() method to do so.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.9 $
 */
public class OOGenTokenIterator implements Enumeration
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient OOGenToken current = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient OOGenToken stopAfter = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean done = false;


   /**
    * Creates a new iterator starting with the specified token
    *
    * @param current  the token where the iterator starts
    */
   public OOGenTokenIterator (OOGenToken current)
   {
      this.current = current;
   }


   /**
    * Constructor for class OOGenTokenIterator
    *
    * @param current    No description provided
    * @param stopAfter  No description provided
    */
   public OOGenTokenIterator (OOGenToken current, OOGenToken stopAfter)
   {
      this.current = current;
      this.stopAfter = stopAfter;
   }


   /**
    * Tests if this Enumeration contains more elements.
    *
    * @return   <code>true</code> if this enumeration contains more elements; <code>false</code>
    *      otherwise.
    */
   public boolean hasMoreElements()
   {
      return  ( (current != null) && !done);
   }


   /**
    * Returns the current element of this enumeration and moves the current pointer to the
    * next element.
    *
    * @return   the current element of this enumeration.
    */
   public Object nextElement()
   {
      Object result = null;

      if (hasMoreElements())
      {
         if (current == stopAfter)
         {
            done = true;
         }
         result = current;
         current = current.getNext();
      }
      else
      {
         throw new NoSuchElementException ("No more elements at the end");
      }

      return result;
   }


   /**
    * Returns the current element of this enumeration and moves the current pointer to the
    * previous element.
    *
    * @return   the current element of this enumeration.
    */
   public Object prevElement()
   {
      Object result = null;

      if (current == null)
      {
         result = current;
         current = current.getPrev();
      }
      else
      {
         throw new NoSuchElementException ("More more elements at the beginning");
      }

      return result;
   }


   /**
    * Returns the current element of this enumeration.
    *
    * @return   the current element of this enumeration.
    */
   public Object get()
   {
      Object result = null;

      if (current != null)
      {
         result = current;
      }
      else
      {
         throw new NoSuchElementException ("More more elements at the beginning");
      }

      return result;
   }
}

/*
 * $Log: OOGenTokenIterator.java,v $
 * Revision 1.9  2004/10/20 17:49:33  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
