/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;



/**
 * Class OOMethodType
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.13 $
 */
public class OOMethodType
{
   // available methods
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType DEFAULT_METHOD = new OOMethodType (0);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType ADD_METHOD = new OOMethodType (DEFAULT_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType REMOVE_METHOD = new OOMethodType (ADD_METHOD);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType GET_METHOD = new OOMethodType (REMOVE_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType IS_METHOD = new OOMethodType (GET_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType SET_METHOD = new OOMethodType (IS_METHOD);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType HAS_IN_METHOD = new OOMethodType (SET_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType ELEMENTS_OF_METHOD = new OOMethodType (HAS_IN_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType ITERATOR_OF_METHOD = new OOMethodType (ELEMENTS_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType OLD_STYLE_ELEMENTS = new OOMethodType (ITERATOR_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType GET_FROM_METHOD = new OOMethodType (OLD_STYLE_ELEMENTS);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType REMOVE_YOU_METHOD = new OOMethodType (GET_FROM_METHOD);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType SIZE_OF_METHOD = new OOMethodType (REMOVE_YOU_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType REMOVE_ALL_FROM_METHOD = new OOMethodType (SIZE_OF_METHOD);

   // Special methods for qualified assocs.
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType GET_VALUE_FROM_METHOD = new OOMethodType (REMOVE_ALL_FROM_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType GET_KEY_FROM_METHOD = new OOMethodType (GET_VALUE_FROM_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType HAS_VALUE_IN_METHOD = new OOMethodType (GET_KEY_FROM_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType HAS_KEY_IN_METHOD = new OOMethodType (HAS_VALUE_IN_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType HAS_ENTRY_IN_METHOD = new OOMethodType (HAS_KEY_IN_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType KEYS_OF_METHOD = new OOMethodType (HAS_ENTRY_IN_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType REMOVE_KEY_FROM_METHOD = new OOMethodType (KEYS_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType REMOVE_VALUE_FROM_METHOD = new OOMethodType (REMOVE_KEY_FROM_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType REMOVE_ENTRY_FROM_METHOD = new OOMethodType (REMOVE_VALUE_FROM_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType IS_EMPTY_METHOD = new OOMethodType (REMOVE_ENTRY_FROM_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType ENTRIES_OF_METHOD = new OOMethodType (IS_EMPTY_METHOD);

   // Special method for ordered assoc
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType GET_AT_METHOD = new OOMethodType (ENTRIES_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType INDEX_OF_METHOD = new OOMethodType (GET_AT_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType LAST_INDEX_OF_METHOD = new OOMethodType (INDEX_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType IS_BEFORE_OF_METHOD = new OOMethodType (LAST_INDEX_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType IS_AFTER_OF_METHOD = new OOMethodType (IS_BEFORE_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType GET_FIRST_OF_METHOD = new OOMethodType (IS_AFTER_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType GET_LAST_OF_METHOD = new OOMethodType (GET_FIRST_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType GET_NEXT_OF_METHOD = new OOMethodType (GET_LAST_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType GET_NEXT_INDEX_OF_METHOD = new OOMethodType (GET_NEXT_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType GET_PREVIOUS_OF_METHOD = new OOMethodType (GET_NEXT_INDEX_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType GET_PREVIOUS_INDEX_OF_METHOD = new OOMethodType (GET_PREVIOUS_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType ADD_BEFORE_OF_METHOD = new OOMethodType (GET_PREVIOUS_INDEX_OF_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType ADD_AFTER_OF_METHOD = new OOMethodType (ADD_BEFORE_OF_METHOD);

   // some other methods
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType EQUALS_METHOD = new OOMethodType (ADD_AFTER_OF_METHOD);

   // container methods
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType ADD_TO_SET_METHOD = new OOMethodType (EQUALS_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethodType SET_CONTAINS_METHOD = new OOMethodType (ADD_TO_SET_METHOD);


   /**
    * Default Constructor
    *
    * @param nr  No description provided
    */
   private OOMethodType (int nr)
   {
      this.nr = nr;
   }


   /**
    * Constructor for class OOMethodType
    *
    * @param prev  No description provided
    */
   private OOMethodType (OOMethodType prev)
   {
      this.nr = prev.getNr() + 1;
   }


   /**
    * UMLAttribute : 'nr : int '
    */
   private int nr;


   /**
    * Get the value of nr.
    *
    * @return   Value of nr.
    */
   public int getNr()
   {
      return this.nr;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param other  No description provided
    * @return       No description provided
    */
   public boolean equals (Object other)
   {
      if (other == null ||
         ! (other instanceof OOMethodType))
      {
         return false;
      }

      return this.nr ==  ((OOMethodType) other).getNr();
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOMethodType[" + this.nr + "]";
   }
}

/*
 * $Log: OOMethodType.java,v $
 * Revision 1.13  2004/12/20 11:49:19  creckord
 * Fixed endless recursion in CodeGenFunction
 *
 */
