/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Iterator;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FLinkedList;


/**
 * Class OONewObjectExpr
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.17 $
 */
public class OONewObjectExpr
    extends OOSingleExpr
{
   /**
    * Default Constructor
    */
   private OONewObjectExpr() { }


   /**
    * Constructor for class OONewObjectExpr
    *
    * @param varType    No description provided
    * @param parameter  No description provided
    */
   public OONewObjectExpr (OOTypeInterface varType,
                           OOExpression parameter)
   {
      this.varType = varType;
      addToParameter (parameter);
   }


   /**
    * <pre>
    *               n       <  hasParameter
    * OOExpression <--------------------------------- OONewObjectExpr
    *               parameter   {ordered,}
    * </pre>
    */
   private FLinkedList parameter;


   /**
    * @param value  No description provided
    * @return       No description provided
    * @see          #parameter
    */
   public boolean hasInParameter (OOExpression value)
   {
      return  ( (this.parameter != null) &&
          (value != null) &&
         this.parameter.contains (value));
   }


   /**
    * @return   No description provided
    * @see      #parameter
    */
   public Iterator iteratorOfParameter()
   {
      return  ( (this.parameter == null)
         ? FEmptyIterator.get()
         : this.parameter.iterator());
   }


   /**
    * @return   No description provided
    * @see      #parameter
    */
   public int sizeOfParameter()
   {
      return  ( (this.parameter == null)
         ? 0
         : this.parameter.size());
   }


   /**
    * @param value  The object added.
    * @return       No description provided
    * @see          #parameter
    */
   public boolean addToParameter (OOExpression value)
   {
      boolean changed = false;
      if (value != null && !hasInParameter (value))
      {
         if (this.parameter == null)
         {
            this.parameter = new FLinkedList(); // or FTreeSet () or FLinkedList ()
         }
         changed = this.parameter.add (value);
      }
      return changed;
   }


   /**
    * @param value  No description provided
    * @return       No description provided
    * @see          #parameter
    */
   public boolean removeFromParameter (OOExpression value)
   {
      boolean changed = false;
      if ( (this.parameter != null) &&  (value != null))
      {
         changed = this.parameter.remove (value);
      }
      return changed;
   }


   /**
    * @see   #parameter
    */
   public void removeAllFromParameter()
   {
      OOExpression tmpValue;
      Iterator iter = this.iteratorOfParameter();
      while (iter.hasNext())
      {
         tmpValue = (OOExpression) iter.next();
         this.removeFromParameter (tmpValue);
      }

   }


   /**
    * @param index  No description provided
    * @return       The parameterAt value
    * @see          #parameter
    */
   public OOExpression getParameterAt (int index)
   {
      if (index >= 0 && index < sizeOfParameter())
      {
         return (OOExpression) this.parameter.get (index);
      }
      else
      {
         throw new IllegalArgumentException ("getParameterAt(" + index + ")");
      }
   }


   /**
    * @param elem  No description provided
    * @return      No description provided
    * @see         #parameter
    */
   public int indexOfParameter (OOExpression elem)
   {
      return  ( (this.parameter == null)
         ? -1
         : this.parameter.indexOf (elem));
   }


   /**
    * @param elem  No description provided
    * @return      No description provided
    * @see         #parameter
    */
   public int lastIndexOfParameter (OOExpression elem)
   {
      return  ( (this.parameter == null)
         ? -1
         : this.parameter.lastIndexOf (elem));
   }


   /**
    * @param lowerBound  No description provided
    * @return            No description provided
    * @see               #parameter
    */
   public Iterator iteratorOfParameter (OOExpression lowerBound)
   {
      Iterator result = FEmptyIterator.get();
      if (parameter == null)
      {
         result = FEmptyIterator.get();
      }
      else if (parameter != null && lowerBound != null)
      {
         int index = parameter.indexOf (lowerBound) + 1;
         result = parameter.listIterator (index);
      }
      else if (parameter != null && lowerBound == null)
      {
         result = parameter.listIterator (0);
      }
      return result;
   }


   /**
    * @param leftObject   No description provided
    * @param rightObject  No description provided
    * @return             The beforeOfParameter value
    * @see                #parameter
    */
   public boolean isBeforeOfParameter (OOExpression leftObject, OOExpression rightObject)
   {
      if (parameter == null)
      {
         return false;
      }
      else
      {
         return parameter.isBefore (leftObject, rightObject);
      }
   }


   /**
    * @param leftObject   No description provided
    * @param rightObject  No description provided
    * @return             The afterOfParameter value
    * @see                #parameter
    */
   public boolean isAfterOfParameter (OOExpression leftObject, OOExpression rightObject)
   {
      if (parameter == null)
      {
         return false;
      }
      else
      {
         return parameter.isAfter (leftObject, rightObject);
      }
   }


   /**
    * @return   The firstOfParameter value
    * @see      #parameter
    */
   public OOExpression getFirstOfParameter()
   {
      if (parameter == null)
      {
         return null;
      }
      else
      {
         return (OOExpression) parameter.getFirst();
      }
   }


   /**
    * @return   The lastOfParameter value
    * @see      #parameter
    */
   public OOExpression getLastOfParameter()
   {
      if (parameter == null)
      {
         return null;
      }
      else
      {
         return (OOExpression) parameter.getLast();
      }
   }


   /**
    * @param object  No description provided
    * @return        The nextOfParameter value
    * @see           #parameter
    */
   public OOExpression getNextOfParameter (OOExpression object)
   {
      if (parameter == null)
      {
         return null;
      }
      else
      {
         return (OOExpression) parameter.getNextOf (object);
      }
   }


   /**
    * @param object  No description provided
    * @param index   No description provided
    * @return        The nextIndexOfParameter value
    * @see           #parameter
    */
   public OOExpression getNextIndexOfParameter (OOExpression object, int index)
   {
      if (parameter == null)
      {
         return null;
      }
      else
      {
         return (OOExpression) parameter.getNextOf (object, index);
      }
   }


   /**
    * @param object  No description provided
    * @return        The previousOfParameter value
    * @see           #parameter
    */
   public OOExpression getPreviousOfParameter (OOExpression object)
   {
      if (parameter == null)
      {
         return null;
      }
      else
      {
         return (OOExpression) parameter.getPreviousOf (object);
      }
   }


   /**
    * @param object  No description provided
    * @param index   No description provided
    * @return        The previousIndexOfParameter value
    * @see           #parameter
    */
   public OOExpression getPreviousIndexOfParameter (OOExpression object, int index)
   {
      if (parameter == null)
      {
         return null;
      }
      else
      {
         return (OOExpression) parameter.getPreviousOf (object, index);
      }
   }


   /**
    * UMLAttribute : 'varType : OOTypeInterface '
    */
   private OOTypeInterface varType;


   /**
    * Get the value of varType.
    *
    * @return   Value of varType.
    */
   public OOTypeInterface getVarType()
   {
      return this.varType;
   }


   /**
    * Get the sourceCode attribute of the OONewObjectExpr object
    *
    * @param visitor  No description provided
    * @return         The sourceCode value
    */
   public String getSourceCode (OOGenVisitor visitor)
   {
      return visitor.getSourceCode (this);
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OONewObjectExpr[" + this.varType + "," +
          (this.parameter != null ? this.parameter.toString() : "") +
         "]";
   }
}

/*
 * $Log: OONewObjectExpr.java,v $
 * Revision 1.17  2004/10/22 16:41:34  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
