/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;



/**
 * Class OOVariableType
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.12 $
 */
public final class OOVariableType
    implements Comparable
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaOrig = new OOVariableType (0);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaSuccess = new OOVariableType (iFujabaOrig);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaAtEnd = new OOVariableType (iFujabaSuccess);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaNextStep = new OOVariableType (iFujabaAtEnd);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaReturnParam = new OOVariableType (iFujabaNextStep);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaEnum = new OOVariableType (iFujabaReturnParam);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaOptional = new OOVariableType (iFujabaEnum);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaFirstBinding = new OOVariableType (iFujabaOptional);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iBreakExceptionVariable = new OOVariableType (iFujabaFirstBinding);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iBreakExceptionText = new OOVariableType (iBreakExceptionVariable);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaTmpObject = new OOVariableType (iBreakExceptionText);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaGoodObject = new OOVariableType (iFujabaTmpObject);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaIter = new OOVariableType (iFujabaGoodObject);

   // hung & kanswa multilink variables
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaFor = new OOVariableType (iFujabaIter);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOVariableType iFujabaUpperBound = new OOVariableType (iFujabaIter);


   /**
    * Default Constructor
    *
    * @param nr  No description provided
    */
   private OOVariableType (int nr)
   {
      this.nr = nr;
   }


   /**
    * Constructor for class OOVariableType
    *
    * @param prev  No description provided
    */
   private OOVariableType (OOVariableType prev)
   {
      this.nr = prev.getNr() + 1;
   }


   /**
    * UMLAttribute : 'nr : int '
    */
   private int nr;


   /**
    * Get the value of nr.
    *
    * @return   Value of nr.
    */
   public int getNr()
   {
      return this.nr;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param other  No description provided
    * @return       No description provided
    */
   public int compareTo (Object other)
   {
      OOVariableType otherType = (OOVariableType) other;

      return nr - otherType.nr;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param other  No description provided
    * @return       No description provided
    */
   public boolean equals (Object other)
   {
      return  (this.compareTo (other) == 0);
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOVariableType[" + this.nr + "]";
   }
}

/*
 * $Log: OOVariableType.java,v $
 * Revision 1.12  2004/10/20 17:49:35  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
