/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.*;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.*;


/**
 * Class ObjectCreateOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14.2.3 $
 */
public class ObjectCreateOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (ObjectCreateOOFunction.class);


   /**
    * Default Constructor
    */
   public ObjectCreateOOFunction() { }


   /**
    * Get the responsible attribute of the ObjectCreateOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.OBJECT_CREATE.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String name;
      String typeStr;
      FType type;
      boolean optional;

      // parse params
      try
      {
         name = (String) param[0];
         type = (FType) param[1];
         typeStr = (String) param[2];
         optional =  ((Boolean) param[3]).booleanValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".objectCreate("
            + "name=" + name
            + ",type=" + type
            + ",optional=" + optional
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment ("create object"));

      if (optional)
      {
         OOStatement.add (statements, OO.ifStat (OO.isNullExpr (name)));
         OOStatement.add (statements, OO.startBlock());
      }

      UMLMethod method =  ((UMLActivityDiagram)  ((UMLStoryActivity)  ((UMLStoryPattern) incr.getParentElement()).getParentElement())
         .getParentElement()).getStartActivity().getSpec();
      boolean isParam = false;
      for (Iterator params = method.iteratorOfParam(); !isParam && params.hasNext(); )
      {
         FParam fParam = (FParam) params.next();
         if (fParam.getName().equals (name))
         {
            isParam = true;
         }
      }
      OOVariable var = OO.variable (name);
      OOType varType;
      if (type != null)
      {
         varType = OO.type (type);
      }
      else
      {
         varType = OO.type (typeStr);
      }

      OOStatement stmt =  (isParam ? OO.assignStat (name, OO.newObject (type)) : OO.varDecl (varType, var, OO.newObject (type)));
      OOStatement.add (statements, stmt);

      if (optional)
      {
         OOStatement.add (statements, OO.endBlock());
      }

      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "ObjectCreateOOFunction[]";
   }
}

/*
 * $Log: ObjectCreateOOFunction.java,v $
 * Revision 1.14.2.3  2005/08/23 08:24:41  lowende
 * Removed compile warnings.
 *
 */
