/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FMethod;


/**
 * @author    <a href="mailto:creckord@upb.de">Carsten Reckord</a>
 * @version   $Revision: 1.4 $
 */
public class StatechartMethodRef extends GeneratedMethodRef
{
   /**
    * Get the StatechartMethodRef attribute of the StatechartMethodRef class
    *
    * @param method  No description provided
    * @return        The StatechartMethodRef value
    */
   public static StatechartMethodRef getStatechartMethodRef (FMethod method)
   {
      StatechartMethodRef ref = (StatechartMethodRef) method.getFromFElementReferences (StatechartMethodRef.class.getName());
      if (ref == null)
      {
         ref = new StatechartMethodRef();
         ref.setMethod (method);
      }
      return ref;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param method  No description provided
    * @return        No description provided
    */
   public static boolean hasStatechartMethodRef (FMethod method)
   {
      return  (method.getFromFElementReferences (StatechartMethodRef.class.getName()) != null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param method  No description provided
    * @return        No description provided
    */
   public static boolean hasAccessedElement (FMethod method)
   {
      return  (hasStatechartMethodRef (method) &&  (getStatechartMethodRef (method).getAccessedElement() != null));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param method   No description provided
    * @param element  No description provided
    * @return         No description provided
    */
   public static StatechartMethodRef createAssociation (FMethod method, FElement element)
   {
      StatechartMethodRef methodRef = getStatechartMethodRef (method);
      AccessedElementRef elementRef = AccessedElementRef.getAccessedElementRef (element);
      elementRef.addToStatechartMethodRef (methodRef);
      return methodRef;
   }


   /**
    * Get the accessedElement attribute of the StatechartMethodRef object
    *
    * @return   The accessedElement value
    */
   public FElement getAccessedElement()
   {
      return  (accessedElementRef == null ? null :
         accessedElementRef.getElement());
   }


   /**
    * Sets the method attribute of the StatechartMethodRef object
    *
    * @param method  The new method value
    * @return        No description provided
    */
   public boolean setMethod (FMethod method)
   {
      return this.setElement (method);
   }


   /**
    * Get the method attribute of the StatechartMethodRef object
    *
    * @return   The method value
    */
   public FMethod getMethod()
   {
      return (FMethod) this.getElement();
   }


   /**
    * <pre>
    *                      0..n          Assoc          0..1
    * StatechartMethodRef ----------------------------------- AccessedElementRef
    *                      methodRef      accessedElementRef
    * </pre>
    */
   private AccessedElementRef accessedElementRef;


   /**
    * Get the accessedElementRef attribute of the StatechartMethodRef object
    *
    * @return   The accessedElementRef value
    */
   public AccessedElementRef getAccessedElementRef()
   {
      return this.accessedElementRef;
   }


   /**
    * Sets the accessedElementRef attribute of the StatechartMethodRef object
    *
    * @param value  The new accessedElementRef value
    * @return       No description provided
    */
   public boolean setAccessedElementRef (AccessedElementRef value)
   {
      boolean changed = false;
      if (this.accessedElementRef != value)
      {
         AccessedElementRef oldValue = this.accessedElementRef;

         if (this.accessedElementRef != null)
         {
            this.accessedElementRef = null;
            oldValue.removeFromStatechartMethodRef (this);
         }
         this.accessedElementRef = value;
         if (value != null)
         {
            value.addToStatechartMethodRef (this);
         }
         changed = true;

      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      AccessedElementRef tmpAccessedElementRef = getAccessedElementRef();
      if (tmpAccessedElementRef != null)
      {
         setAccessedElementRef (null);
      }
   }
}

/*
 * $Log: StatechartMethodRef.java,v $
 * Revision 1.4  2004/10/22 16:41:34  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
