/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Iterator;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.*;


/**
 * Class UMLProjectOOHandler
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.15.2.1 $
 */
public class UMLProjectOOHandler
    extends OOGenStrategyHandler
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UMLProjectOOHandler.class);


   /**
    * Default Constructor
    */
   public UMLProjectOOHandler()
   {
      super();
   }


   /**
    * Get the responsible attribute of the UMLProjectOOHandler object
    *
    * @param incr  No description provided
    * @return      The responsible value
    */
   public boolean isResponsible (FElement incr)
   {
      return  (incr instanceof FProject);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public final boolean needToken()
   {
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr       No description provided
    * @param prevToken  No description provided
    * @param param      No description provided
    * @return           No description provided
    */
   public OOGenToken generateSourceCode (FElement incr,
                                         OOGenToken prevToken,
                                         Object param[])
   {
      FProject theProject = (FProject) incr;

      if (log.isDebugEnabled())
      {
         log.debug (this + ".generateSourceCode(theProject=" + theProject + ")");
      }

      FFile tmpFile = null;
      Iterator fileIter = theProject.iteratorOfFiles();

      CodeGenException exception = new CodeGenException();
      while (fileIter.hasNext())
      {
         tmpFile = (FFile) fileIter.next();
         if (tmpFile.sizeOfContains() > 0)
         {
            try
            {
               // generateFFile
               getClientOfChain().generateSourceCodeFor (tmpFile,
                  null,
                  null);
            }
            catch (RuntimeException e)
            {
               exception.addToExceptions (e);
            }
         }
         else
         {
            // tmpFile is obsolete
            tmpFile.removeYou();
         }
      }
      if (exception.sizeOfExceptions() > 0)
      {
         throw exception;
      }

      // has no tokens
      return null;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLProjectOOHandler[]";
   }
}

/*
 * $Log: UMLProjectOOHandler.java,v $
 * Revision 1.15.2.1  2005/08/23 08:24:42  lowende
 * Removed compile warnings.
 *
 */
