/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Set;

import de.uni_paderborn.fujaba.basic.SourceCodeFactory;
import de.uni_paderborn.fujaba.codegen.AccessorOOHandler.MethodDescription;
import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.tools.fca.FHashMap;


/**
 * @author    Carsten Reckord
 * @version   $Revision: 1.5 $
 */
public abstract class UMLRoleOOHandlerQualifiedStrategy extends UMLRoleOOHandlerToManyStrategy
{

   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             The responsible value
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#isResponsible(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   public boolean isResponsible (FRole umlRole, FRole partnerRole)
   {
      return  (umlRole != null && partnerRole != null &&
         umlRole.getFQualifier() != null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    */
   protected FHashMap setupTemplateParameters (FRole umlRole, FRole partnerRole)
   {
      FHashMap templateParameters = super.setupTemplateParameters (umlRole, partnerRole);

      FQualifier umlQualifier = umlRole.getFQualifier();
      FType qualifierType = umlQualifier.getFType();
      templateParameters.put ("$KEYTYPE$", qualifierType.getName());

      if (qualifierType instanceof FClass)
      {
         provideImport (umlRole.getFTarget(), (FClass) qualifierType);
      }

      return templateParameters;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected abstract void generateReadAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                                      FHashMap templateParameters, Set accessMethods);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected abstract void generateWriteAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                                       FHashMap templateParameters, Set accessMethods);


   /**
    * Get the containerType attribute of the UMLRoleOOHandlerQualifiedStrategy object
    *
    * @return   The containerType value
    */
   protected abstract OOCollectionEnum getContainerType();


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createHasValueInMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      return createHasInMethod (umlRole, partnerRole, attr, templateParameters, "assoc-hasIn-v1A");
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createHasKeyInMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.HAS_KEY_IN_METHOD;
      String blockName = "assoc-hasKeyIn-v1";

      FType returnType = UMLProject.get().getFromBaseTypes (FBaseTypes.BOOLEAN);

      FParam keyParam = createParam ("key", umlRole.getFQualifier().getFType());

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, new FParam[]{keyParam});
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createIteratorOfMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      return createIteratorOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-iteratorOf-v2");
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createKeysOfMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      return createIteratorOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-keysOf-v1", SourceCodeFactory.KEYS_OF_METHOD);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createEntriesOfMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      return createIteratorOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-entriesOf-v1", SourceCodeFactory.ENTRIES_OF_METHOD);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createAddToMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.ADD_METHOD;
      String blockName = "assoc-addTo-v4";

      String remove = getPartnerAccessMethod (umlRole, partnerRole, SourceCodeFactory.REMOVE_METHOD);
      templateParameters.put ("$REMOVE$", remove);

      return createInsertMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType, true);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createAddToMapEntryMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.ADD_METHOD;
      String blockName = "assoc-addTo-v6";

      FType paramType = provideReference (getMapEntryType (umlRole.getFQualifier().getFType(),
         partnerRole.getFTarget().getFRealType()));

      return createInsertMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType, "entry", paramType, false);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createRemoveValueFromMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.REMOVE_METHOD;
      String blockName = "assoc-removeFrom-v4";

      return createRemoveMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @param methodType          No description provided
    * @param paramName           No description provided
    * @param paramType           No description provided
    * @return                    No description provided
    */
   protected MethodDescription createInsertMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                   FHashMap templateParameters, String blockName, int methodType,
                                                   String paramName, FType paramType)
   {
      return createInsertMethod (umlRole, partnerRole, attr, templateParameters, blockName,
         methodType, paramName, paramType, true);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @param methodType          No description provided
    * @return                    No description provided
    */
   protected MethodDescription createInsertMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                   FHashMap templateParameters, String blockName, int methodType)
   {
      return createInsertMethod (umlRole, partnerRole, attr, templateParameters, blockName,
         methodType, true);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @param methodType          No description provided
    * @param paramName           No description provided
    * @param paramType           No description provided
    * @param qualified           No description provided
    * @return                    No description provided
    */
   protected MethodDescription createInsertMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                   FHashMap templateParameters, String blockName, int methodType,
                                                   String paramName, FType paramType, boolean qualified)
   {
      MethodDescription description = super.createInsertMethod (umlRole, partnerRole, attr, templateParameters, blockName,
         methodType, paramName, paramType);

      if (qualified)
      {
         return addQualifier (umlRole, partnerRole, description);
      }
      return description;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @param methodType          No description provided
    * @param qualified           No description provided
    * @return                    No description provided
    */
   protected MethodDescription createInsertMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                   FHashMap templateParameters, String blockName,
                                                   int methodType, boolean qualified)
   {
      return createInsertMethod (umlRole, partnerRole, attr, templateParameters, blockName, methodType,
         "value", partnerRole.getFTarget().getFRealType(), qualified);
   }


   /**
    * Access method for an one to n association.
    *
    * @param umlRole      The object added.
    * @param partnerRole  The object added.
    * @param description  The object added.
    * @return             No description provided
    */
   protected MethodDescription addQualifier (FRole umlRole, FRole partnerRole,
                                             MethodDescription description)
   {
      return addQualifier (description, umlRole.getFQualifier().getFType(),
          (getExternalQualifierType (partnerRole) != null));
   }


   /**
    * Access method for an one to n association.
    *
    * @param description       The object added.
    * @param qualifierType     The object added.
    * @param partnerQualified  The object added.
    * @return                  No description provided
    */
   protected MethodDescription addQualifier (MethodDescription description, FType qualifierType,
                                             boolean partnerQualified)
   {
      FMethod method = description.getMethodSignature();
      FParam keyParam = createParam ("key", qualifierType);

      int insertPos = 0;
      if (partnerQualified)
      {
         insertPos++;
      }
      method.addToParam (insertPos, keyParam);

      return description;
   }


   /**
    * Get the partnerAccessMethod attribute of the UMLRoleOOHandlerQualifiedStrategy object
    *
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @param methodType   No description provided
    * @return             The partnerAccessMethod value
    */
   protected String getPartnerAccessMethod (FRole umlRole, FRole partnerRole, int methodType)
   {
      boolean remove =  (methodType == SourceCodeFactory.REMOVE_METHOD);
      boolean toOne = !isToMany (partnerRole, umlRole);
      boolean qualified =  ( (toOne || !remove) &&  (getExternalQualifierType (umlRole) != null));
      boolean partnerQualified = !remove &&  (getExternalQualifierType (partnerRole) != null);

      return getPartnerAccessMethod (umlRole, partnerRole, methodType, qualified, partnerQualified);
   }


   /**
    * Get the mapEntryType attribute of the UMLRoleOOHandlerQualifiedStrategy class
    *
    * @param keyType    No description provided
    * @param valueType  No description provided
    * @return           The mapEntryType value
    */
   protected final static String getMapEntryType (FType keyType, FType valueType)
   {
      OOGenVisitor visitor = CodeGenFactory.get().getCurrentOOVisitor();
      return visitor.getOOTypeAsString (
         OO.containerType (OOCollectionEnum.KEY_VALUE_PAIR, new OOType[]{
         OO.type (keyType,  (keyType instanceof FBaseTypes)),
         OO.type (valueType,  (valueType instanceof FBaseTypes))}), false);
   }
}

/*
 * $Log: UMLRoleOOHandlerQualifiedStrategy.java,v $
 * Revision 1.5  2004/11/22 19:04:49  lowende
 * Some javadoc corrections.
 *
 */
