/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Set;

import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FRole;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.upb.tools.fca.FHashMap;


/**
 * @author    Carsten Reckord
 * @version   $Revision: 1.6.2.3 $
 */
public class UMLRoleOOHandlerSortedToManyStrategy extends UMLRoleOOHandlerToManyStrategy
{
   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             The responsible value
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#isResponsible(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   public boolean isResponsible (FRole umlRole, FRole partnerRole)
   {
      return  (umlRole != null && partnerRole != null &&
         getCardinality (partnerRole) > 1 && isSorted (partnerRole) &&
         umlRole.getFQualifier() == null);
   }


   /**
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateReadAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                             FHashMap templateParameters, Set accessMethods)
   {
      super.generateReadAccessMethods (umlRole, partnerRole, attr, templateParameters, accessMethods);
      generateFirstLastReadAccessMethods (umlRole, partnerRole, attr, templateParameters, accessMethods);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    */
   protected String generateContructorParam (FRole umlRole, FRole partnerRole)
   {
      StringBuffer paramBuffer = new StringBuffer();
      paramBuffer.append ("new ").append ( ((UMLAssoc) umlRole.getFAssoc()).getSortedComparator())
         .append ("()");

      String constructorParam = super.generateContructorParam (umlRole, partnerRole);
      if (constructorParam != null && constructorParam.length() > 0)
      {
         paramBuffer.append (", ").append (constructorParam);
      }

      return paramBuffer.toString();
   }


   /**
    * Get the containerType attribute of the UMLRoleOOHandlerSortedToManyStrategy object
    *
    * @return   The containerType value
    */
   protected OOCollectionEnum getContainerType()
   {
      return OOCollectionEnum.TREESET;
   }
}

/*
 * $Log: UMLRoleOOHandlerSortedToManyStrategy.java,v $
 * Revision 1.6.2.3  2006/02/16 17:36:08  l3_g5
 * checkout cxr ant task added
 *
 */
