/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLStatementActivity;


/**
 * Class UMLStatementActivityHandler
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.19 $
 */
public class UMLStatementActivityOOHandler
    extends OOGenStrategyHandler
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UMLStatementActivityOOHandler.class);


   /**
    * Default Constructor
    */
   public UMLStatementActivityOOHandler()
   {
      super();
   }


   /**
    * Get the responsible attribute of the UMLStatementActivityOOHandler object
    *
    * @param incr  No description provided
    * @return      The responsible value
    */
   public boolean isResponsible (FElement incr)
   {
      return  (incr instanceof UMLStatementActivity);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public final boolean needToken()
   {
      return true;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr       No description provided
    * @param prevToken  No description provided
    * @param param      No description provided
    * @return           No description provided
    */
   public OOGenToken generateSourceCode (FElement incr,
                                         OOGenToken prevToken,
                                         Object param[])
   {
      UMLStatementActivity theActivity = (UMLStatementActivity) incr;

      if (log.isDebugEnabled())
      {
         log.debug (this + ".generateSourceCode(theActivity=" + theActivity + ")");
      }

      OOGenToken current;
      OOGenToken lastToken;
      String section;
      OOGenStrategyClient client = (OOGenStrategyClient) getClientOfChain();

      current = CodeGenStrategy.checkTokenList (theActivity, prevToken, theActivity.getFirstOOGenToken(), theActivity.getLastOOGenToken());
      lastToken = theActivity.getLastOOGenToken();

      section = current.newSection ("StatementActivity", lastToken);
      current = current.getNextOrAppend (section, lastToken);
      if (theActivity.getState() != null && theActivity.getState().getStatement() != null)
      {
         current.appendStatement (client.memoField (theActivity.getState().getStatement()));
      }
      //      current.appendText ("\n");
      // delete superfluous tokens in the list
      current.deleteToSection (null, lastToken);

      return lastToken;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLStatementActivityOOHandler[]";
   }
}

/*
 * $Log: UMLStatementActivityOOHandler.java,v $
 * Revision 1.19  2004/10/20 17:49:36  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
