/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen.digester;


import org.xml.sax.Attributes;


/**
 * Concrete implementations of this class implement actions to be taken when a corresponding
 * nested pattern of XML elements has been matched.
 *
 * @author    Craig McClanahan
 * @version   $Revision: 1.7 $ $Date: 2004/10/29 13:46:53 $
 */
public abstract class XRule
{
   /**
    * Default constructor sets only the the associated Digester.
    *
    * @param digester  The digester with which this rule is associated
    */
   public XRule (XDigester digester)
   {
      super();
      this.digester = digester;
   }


   /**
    * The Digester with which this Rule is associated.
    */
   protected XDigester digester = null;


   // --------------------------------------------------------- Public Methods


   /**
    * This method is called when the beginning of a matching XML element is encountered.
    *
    * @param attributes  The attribute list of this element
    * @throws Exception  Exception description not provided
    */
   public void begin (Attributes attributes) throws Exception
   {

      ; // The default implementation does nothing

   }


   /**
    * This method is called when the body of a matching XML element is encountered. If the
    * element has no body, this method is not called at all.
    *
    * @param text        The text of the body of this element
    * @throws Exception  Exception description not provided
    */
   public void body (String text) throws Exception
   {

      ; // The default implementation does nothing

   }


   /**
    * This method is called when the end of a matching XML element is encountered.
    *
    * @throws Exception  Exception description not provided
    */
   public void end() throws Exception
   {

      ; // The default implementation does nothing

   }



   /**
    * This method is called after all parsing methods have been called, to allow Rules to remove
    * temporary data.
    *
    * @throws Exception  Exception description not provided
    */
   public void finish() throws Exception
   {

      ; // The default implementation does nothing

   }

}

/*
 * $Log: XRule.java,v $
 * Revision 1.7  2004/10/29 13:46:53  lowende
 * Some improvements for parsed code
 *
 */
