/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * @author    christian.schneider@uni-kassel.de
 * @version   $Revision: 1.6 $ $Date: 2004/11/03 10:17:50 $
 */
public class RecoverDialog extends JDialog
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JPanel base;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void init()
   {
      getRootPane().setLayout (new BorderLayout());
      base = new JPanel();
      getRootPane().add (base, BorderLayout.CENTER);
      GridLayout grid = new GridLayout();
      grid.setColumns (1);
      grid.setRows (0);
      base.setLayout (grid);
      JPanel top = new JPanel();
      getRootPane().add (top, BorderLayout.NORTH);
      JLabel label = new JLabel ("Temporary files of past Fujaba sessions were found. Do you wish to recover any of these?");
      top.setPreferredSize (new Dimension ((int) label.getPreferredSize().getWidth() + 20, (int) label.getPreferredSize().getHeight() + 20));
      FlowLayout flow = new FlowLayout (FlowLayout.CENTER);
      top.setLayout (flow);
      top.add (label);
   }


   /**
    * Creates a modal dialog without "Recover" as title with the specified <code>Frame</code>
    * as its owner. <p>
    *
    * This constructor sets the component's locale property to the value returned by <code>JComponent.getDefaultLocale</code>
    * .
    *
    * @param owner               the non-null <code>Dialog</code> from which the dialog is
    *      displayed
    * @see                       GraphicsEnvironment#isHeadless
    * @see                       JComponent#getDefaultLocale
    * @throws HeadlessException  Exception description not provided
    */
   public RecoverDialog (Frame owner) throws HeadlessException
   {
      super (owner, "Recover", true);
      init();
   }


   /**
    * called to show all files stored by the immedate store feature of {@link de.tu_bs.coobra.LocalRepository}
    * if any
    */
   public void check()
   {
      boolean foundFiles = false;
      File dir = new File (".");
      String[] files = dir.list();
      for (int i = 0; i < files.length; i++)
      {
         String fileName = files[i];
         File file = new File (dir, fileName);
         if (!file.isDirectory() && fileName.startsWith ("~") && fileName.endsWith (".cxri"))
         {
            if (UMLProject.get().getBackupFile() == null || !fileName.equals (UMLProject.get().getBackupFile().getName()))
            {
               foundFiles = true;
               JPanel filePanel = new JPanel();
               filePanel.putClientProperty ("file", file);
               filePanel.setLayout (new FlowLayout (FlowLayout.CENTER));

               JButton loadButton = new JButton (fileName);
               filePanel.add (loadButton);
               loadButton.addActionListener (
                  new ActionListener()
                  {
                     /**
                      * Invoked when an action occurs.
                      *
                      * @param e  No description provided
                      */
                     public void actionPerformed (ActionEvent e)
                     {
                        JComponent parent =  ((JComponent)  ((JComponent) e.getSource()).getParent());
                        load (parent);
                     }
                  });

               JButton deleteButton = new JButton ("delete");
               filePanel.add (deleteButton);
               deleteButton.addActionListener (
                  new ActionListener()
                  {
                     /**
                      * Invoked when an action occurs.
                      *
                      * @param e  No description provided
                      */
                     public void actionPerformed (ActionEvent e)
                     {
                        JComponent parent =  ((JComponent)  ((JComponent) e.getSource()).getParent());
                        delete (parent);
                     }
                  });

               base.add (filePanel);
            }
         }
      }

      JButton noneButton = new JButton ("no");
      JPanel nonePanel = new JPanel();
      nonePanel.setLayout (new FlowLayout (FlowLayout.CENTER));
      nonePanel.add (noneButton);
      base.add (nonePanel);
      noneButton.addActionListener (
         new ActionListener()
         {
            /**
             * Invoked when an action occurs.
             *
             * @param e  No description provided
             */
            public void actionPerformed (ActionEvent e)
            {
               dispose();
            }
         });

      if (foundFiles)
      {
         pack();
         center();
         show();
      }
   }


   /**
    * @param parent  which filePanel caused the request
    */
   void delete (JComponent parent)
   {
      File file = (File) parent.getClientProperty ("file");
      if (file.delete())
      {
         parent.setVisible (false);
      }
      else
      {
         JOptionPane.showMessageDialog (this, "Delete failed! Maybe file is in use?", "Delete", JOptionPane.ERROR_MESSAGE);
      }
   }


   /**
    * @param parent  which filePanel caused the request
    */
   void load (JComponent parent)
   {
      File file = (File) parent.getClientProperty ("file");
      FrameMain.get().openFile (file);
      dispose();
   }


   /**
    * center the frame
    */
   private void center()
   {
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      Dimension frameSize = this.getSize();
      if (frameSize.height > screenSize.height)
      {
         frameSize.height = screenSize.height;
      }
      if (frameSize.width > screenSize.width)
      {
         frameSize.width = screenSize.width;
      }
      this.setLocation ( (screenSize.width - frameSize.width) / 2,  (screenSize.height - frameSize.height) / 2);
   }
}

/*
 * $Log: RecoverDialog.java,v $
 * Revision 1.6  2004/11/03 10:17:50  lowende
 * Javadoc warnings removed.
 *
 */
