/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra.actions;

import java.awt.*;
import java.awt.event.ActionEvent;

import javax.swing.*;

import de.tu_bs.coobra.*;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.action.UpdateProjectTreeAction;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Redo one chunk of changes in the VM repository
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.11 $
 */
public class RedoAction extends AbstractAction
{
   /**
    * Perform the action
    *
    * @param event  the ActionEvent for performing the action
    */
   public void actionPerformed (ActionEvent event)
   {
      LocalRepository repo = FujabaChangeManager.getVMRepository();
      if (repo != null && repo.isRedoPossible())
      {
         ObjectChange change = repo.getFirstFromUndone();
         ObjectChangeCause cause = change;
         while (cause instanceof ObjectChange)
         {
            cause = change.getCause();
         }
         if (cause instanceof ObjectChangeStringCause)
         {
            FrameMain.get().setStatusLabel ("redone: " + cause.toString());
         }

         repo.redo (1);
         FujabaChangeManager.updateUndoRedoActions();

         if (cause == null && repo.isRedoPossible())
         {
            actionPerformed (event);
         }
         else
         {
            UMLProject.get().refreshDisplay();
            new UpdateProjectTreeAction().actionPerformed (null);
         }
      }
      else
      {
         Toolkit.getDefaultToolkit().beep();
         if (repo == null)
         {
            FrameMain.get().setStatusLabel ("Undo/Redo is deactivated!");
         }
         else
         {
            FrameMain.get().setStatusLabel ("Nothing to redo!!");
         }
      }
   }
}

/*
 * $Log: RedoAction.java,v $
 * Revision 1.11  2005/01/27 15:44:45  cschneid
 * bugfixes, new libraries, SDMObjectDialog improved, add activity in transition
 *
 */
