/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra.actions;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.*;

import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;


/**
 * Show all changes in the list of changes and the undone changes from the VMs repository
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.9 $
 */
public class ShowChangesAction extends AbstractAction
{
   /**
    * A little frame that presents a list of objects
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.9 $
    */
   private static class ChangesListFrame extends JFrame
   {
      /**
       * ctor
       *
       * @param title    Title of the Frame
       * @param changes  Iterator through objects that will be displayed
       */
      public ChangesListFrame (String title, Iterator changes)
      {
         super (title);
         JList list = new JList();
         Vector vector = new Vector();

         while (changes.hasNext())
         {
            Object change = changes.next();
            vector.add (change);
         }

         list.setListData (vector);
         JScrollPane scrollPane = new JScrollPane (list);

         scrollPane.setMaximumSize (new Dimension (1000, 300));
         Dimension preferredSize = scrollPane.getPreferredSize();
         if (preferredSize.width > 1000)
         {
            preferredSize.width = 1000;
            scrollPane.setPreferredSize (preferredSize);
         }

         getContentPane().setLayout (new BorderLayout());
         getContentPane().add (scrollPane, BorderLayout.CENTER);

         pack();
         show();
      }
   }


   /**
    * perform the action
    *
    * @param e
    */
   public void actionPerformed (ActionEvent e)
   {
      new ChangesListFrame ("changes",
         FujabaChangeManager.getVMRepository().iteratorOfChanges());
      new ChangesListFrame ("undone changes",
         FujabaChangeManager.getVMRepository().iteratorOfUndone());
      new ChangesListFrame ("changes base",
         FujabaChangeManager.getVMRepository().iteratorOfChangesBase());
   }
}

/*
 * $Log: ShowChangesAction.java,v $
 * Revision 1.9  2004/11/03 10:17:51  lowende
 * Javadoc warnings removed.
 *
 */
