/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra.actions;

import java.awt.event.ActionEvent;
import java.io.InputStream;

import javax.swing.*;

import de.tu_bs.coobra.LocalRepository;
import de.tu_bs.coobra.remote.ServerRepositoryImpl;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.action.NewProjectAction;
import de.uni_paderborn.fujaba.app.action.OpenProjectAction;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public class StartServerRepositoryAction extends AbstractAction
{

   /**
    * Creates a new instance of SaveAsAction
    */
   public StartServerRepositoryAction() { }


   /**
    * dialog for choosing ior/name mode and nameserver,port
    */
   private static SelectServerRepositoryDialog dialog;


   /**
    * This method is called when the action shall be performed.
    *
    * @param e  Event that caused the action
    */
   public void actionPerformed (ActionEvent e)
   {
      startServerRepository (null);
   }


   /**
    * Start a ServerRepository
    *
    * @param in  InputStream to read initial content (null for new project)
    */
   public void startServerRepository (InputStream in)
   {

      //ask where to register service
      if (dialog == null)
      {
         dialog = new SelectServerRepositoryDialog (FrameMain.get(), true);
         dialog.setTitle ("Start Server");
         dialog.setIOR ("will be generated");
         dialog.setIOREnabled (false);
      }
      dialog.show();

      boolean importFPR = in == null && JOptionPane.showConfirmDialog (FrameMain.get()
         , "Do you want to import an FPR-File (XML does not work)?"
         , "Start Server", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION;

      if (dialog.isOk())
      {
         try
         {
            if (FujabaChangeManager.getVMRepository() != null)
            {
               FujabaChangeManager.getVMRepository().setWriteProtected (false);
            }
            UMLProject.setNewProject (null);

            ServerRepositoryImpl impl;
            if (dialog.isByName())
            {
               impl = ServerRepositoryImpl.run (
                  dialog.getNameServer(), dialog.getNameServerPort(),
                  dialog.getRepositoryName(), null, in);
            }
            else
            {
               impl = ServerRepositoryImpl.run (null, in);
            }

            LocalRepository repo = impl.getLocalRepository();
            FujabaChangeManager.setVMRepository (repo);

            if (in == null)
            {
               ActionEvent ev = new ActionEvent (this, 0, null);
               if (!importFPR)
               {
                  new NewProjectAction().actionPerformed (ev);
               }
               else
               {

                  new OpenProjectAction().actionPerformed (ev);
               }
            }

            repo.setWriteProtected (true);

            FrameMain.get().setStatusLabel ("start of server succeeded");

         }
         catch (Exception ex)
         {
            ex.printStackTrace();
            FrameMain.get().setStatusLabel ("start of server failed");
            JOptionPane.showMessageDialog (FrameMain.get(), "Start of server failed: " + ex.getMessage());
         }
      }
   }

}

/*
 * $Log: StartServerRepositoryAction.java,v $
 * Revision 1.11  2004/10/20 17:49:39  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
