/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.awt.*;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.*;

import javax.swing.*;
import javax.swing.border.LineBorder;
import javax.swing.event.*;

import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;


/**
 * UMLClass: 'FSAEditorPane'
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.20 $
 */
public class FSAEditorPane extends FSAContainer
{
   /**
    * Constructor for class FSAEditorPane
    *
    * @param incr  No description provided
    */
   public FSAEditorPane (LogicUnparseInterface incr)
   {
      this (incr, null);
   }


   /**
    * Constructor for class FSAEditorPane
    *
    * @param incr    No description provided
    * @param parent  No description provided
    */
   public FSAEditorPane (LogicUnparseInterface incr, JComponent parent)
   {
      super (incr, null, parent);
   }


   /**
    * Constructor for class FSAEditorPane
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSAEditorPane (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public static HyperlinkListener linkListener = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JEditorPane myjeditorpane = null;


   /**
    * Sets the pane attribute of the FSAEditorPane object
    *
    * @param newPane  The new pane value
    */
   public void setPane (JEditorPane newPane)
   {
      myjeditorpane = newPane;
   }


   /**
    * Get the pane attribute of the FSAEditorPane object
    *
    * @return   The pane value
    */
   public JEditorPane getPane()
   {
      return myjeditorpane;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public JEditorPane findPane()
   {
      JComponent jcomp = this.getJComponent();
      while (jcomp != null && ! (jcomp instanceof JEditorPane))
      {
         jcomp = (JComponent) jcomp.getComponent (0);
      }
      myjeditorpane = (JEditorPane) jcomp;

      return myjeditorpane;
   }


   /**
    * creates a standard JLayeredPane with frame for this FSAFrame UMLMethod: '+ createJComponent
    * () : Void'
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      setPane (new JEditorPane());
      getPane().setContentType ("text/html");
      getPane().setText ("<body><h1>empty document</h1></body>");
      getPane().setEditable (false);

      if (linkListener != null)
      {
         JEditorPane myPane = this.getPane();
         myPane.addHyperlinkListener (linkListener);
         myPane.addCaretListener ((CaretListener) linkListener);
      }

      /*
       *  JPanel jp = new JPanel();
       *  jp.setLayout (new BorderLayout ());
       *  JScrollPane scroller = new JScrollPane ();
       *  scroller.setPreferredSize (new Dimension (400, 300));
       *  scroller.setBorder (new SoftBevelBorder (BevelBorder.LOWERED));
       *  JViewport vp = scroller.getViewport ();
       *  vp.add (getPane ());
       *  vp.setScrollMode (JViewport.BACKINGSTORE_SCROLL_MODE);
       *  jp.add (scroller, BorderLayout.CENTER);
       */
      JScrollPane jp = new JScrollPane (getPane());

      jp.getAccessibleContext().setAccessibleName ("HTML panel");
      jp.getAccessibleContext().setAccessibleDescription ("A panel for viewing HTML documents, and following their links");

      return jp;
   }


   /**
    * Sets the specified LayoutManager for the associated JLayeredPane.
    *
    * @param layout  The new layout value
    */
   public void setLayout (LayoutManager layout)
   {
      getJComponent().setLayout (layout);
   }


   /**
    * Access method for an one to n association.
    *
    * @param object  The object added.
    */
   public void addToChildren (FSAObject object)
   {
      JComponent comp = object.getJComponent();
      JLayeredPane pane = (JLayeredPane) getJComponent();
      if (comp != null && pane != null)
      {
         pane.setLayer (comp, JLayeredPane.DEFAULT_LAYER.intValue(), 0);
      }
      super.addToChildren (object);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param object  No description provided
    */
   public void removeFromChildren (FSAObject object)
   {
      super.removeFromChildren (object);
      JComponent myComp = getJComponent();
      if (myComp != null && object != null && object.getJComponent() != null)
      {
         myComp.repaint();
      }
   }


   /**
    * update the jComponent to reflect this value
    *
    * @param value  The new jComponentValue value
    */
   public void setJComponentValue (Object value) { }


   /**
    * get the value that is currently visualised by the jComponent
    *
    * @return   The jComponentValue value
    */
   public Object getJComponentValue()
   { // FSAObject

      return null;
   }


   /**
    * Sets the selected attribute of the FSAEditorPane object
    *
    * @param selected  The new selected value
    */
   public void setSelected (boolean selected) { }


   /**
    * Get the selected attribute of the FSAEditorPane object
    *
    * @return   The selected value
    */
   public boolean isSelected()
   {
      return false;
   }


   /**
    * Sets the focused attribute of the FSAEditorPane object
    *
    * @param focused  The new focused value
    */
   public void setFocused (boolean focused) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.20 $
    */
   class PaneMouseAdapter extends MouseInputAdapter
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private Point relativePositionOnPress;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private JPanel panel;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private HashSet selected;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private HashSet unselected;


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mousePressed (MouseEvent e)
      {
         if ( (e.getModifiers() & InputEvent.CTRL_MASK) == 0 &&
             (e.getModifiers() & InputEvent.SHIFT_MASK) == 0)
         {
            SelectionManager.get().clear();
         }
         relativePositionOnPress = e.getPoint();
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseReleased (MouseEvent e)
      {
         if (panel != null)
         {
            getJComponent().remove (panel);
            getJComponent().repaint();
            panel = null;
         }
         relativePositionOnPress = null;
         unselected = null;
         selected = null;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseDragged (MouseEvent e)
      {
         SelectionManager manager = SelectionManager.get();
         Vector changed = null;
         if (panel == null)
         {
            panel = new JPanel();
            panel.setOpaque (false);
            panel.setBorder (new LineBorder (ColorsPreferences.get().SELECTION_RECT));
            getJComponent().add (panel, JLayeredPane.DRAG_LAYER);
         }
         if (selected == null || unselected == null)
         {
            int maxSize = 0;
            if (getChildConnector() != null)
            {
               maxSize = getChildConnector().getComponentCount();
            }

            unselected = new HashSet (maxSize);
            selected = new HashSet (maxSize);

            Iterator childIter = iteratorOfChildren();
            while (childIter.hasNext())
            {
               FSAObject child = (FSAObject) childIter.next();

               if (child.isSelected())
               {
                  selected.add (child);
               }
               else
               {
                  unselected.add (child);
               }
            }
         }

         Point newLocation = e.getPoint();
         if (relativePositionOnPress == null)
         {
            relativePositionOnPress = newLocation;
         }

         Rectangle bounds =
            new Rectangle (Math.min (newLocation.x, relativePositionOnPress.x),
            Math.min (newLocation.y, relativePositionOnPress.y),
            Math.abs (newLocation.x - relativePositionOnPress.x),
            Math.abs (newLocation.y - relativePositionOnPress.y));
         Rectangle oldBounds = panel.getBounds();
         panel.setBounds (bounds);

         if (!bounds.contains (oldBounds))
         {
            changed = new Vector();
            Rectangle[] removedAreas = SwingUtilities.computeDifference (oldBounds, bounds);
            Iterator selIter = selected.iterator();

            while (selIter.hasNext())
            {
               FSAObject selObject = (FSAObject) selIter.next();
               JComponent selComp = selObject.getJComponent();

               if (selComp != null)
               {
                  Rectangle selBounds = selComp.getBounds();

                  for (int i = 0; i < removedAreas.length; i++)
                  {
                     if (removedAreas[i].intersects (selBounds))
                     {
                        manager.setSelected (selComp, false, true);
                        selIter.remove();
                        changed.add (selObject);
                        break;
                     }
                  }
               }
            }
         }

         if (!oldBounds.contains (bounds))
         {
            Iterator unselIter = unselected.iterator();

            while (unselIter.hasNext())
            {
               FSAObject unselObject = (FSAObject) unselIter.next();
               JComponent unselComp = unselObject.getJComponent();

               if (unselComp != null)
               {
                  Rectangle unselBounds = unselComp.getBounds();

                  if (bounds.contains (unselBounds))
                  {
                     manager.setSelected (unselComp, true, true);
                     unselIter.remove();
                     selected.add (unselObject);
                     break;
                  }
               }
            }
         }

         if (changed != null)
         {
            unselected.addAll (changed);
         }
      }
   }
}

/*
 * $Log: FSAEditorPane.java,v $
 * Revision 1.20  2004/11/03 10:17:52  lowende
 * Javadoc warnings removed.
 *
 */
