/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * fsaObject for JGrab</p> A JGrab is a JBend that is attached to another JComponent and changes
 * position with it.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.19.2.2 $
 * @see       de.uni_paderborn.fujaba.fsa.swing.JGrab
 * @see       de.uni_paderborn.fujaba.fsa.swing.JBend
 */
public class FSAGrab extends FSABend
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ALIGNMENT = "alignment";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ORIENTATION = "orientation";


   /**
    * Constructor for class FSAGrab
    *
    * @param incr      No description provided
    * @param propName  No description provided
    */
   public FSAGrab (LogicUnparseInterface incr, String propName)
   {
      super (incr, propName);
   }


   /**
    * Constructor for class FSAGrab
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSAGrab (LogicUnparseInterface incr,
                   String propName,
                   JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Constructor for class FSAGrab
    *
    * @param incr          No description provided
    * @param propName      No description provided
    * @param parent        No description provided
    * @param myJComponent  No description provided
    */
   public FSAGrab (LogicUnparseInterface incr,
                   String propName,
                   JComponent parent,
                   JComponent myJComponent)
   {
      super (incr, propName, parent, myJComponent);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JGrab grab = new JGrab();
      grab.setUI ((GrabUI) DefaultGrabUI.createUI (grab));
      //grab.setVisible (false);

      return  (grab);
   }


   /**
    * set the target of the grab to the jComponent of obj.
    *
    * @param obj  The new target value
    * @return     No description provided
    * @see        de.uni_paderborn.fujaba.fsa.swing.JGrab#setTarget
    */
   public boolean setTarget (FSAObject obj)
   {
      JGrab grab = (JGrab) getJComponent();

      if (grab == null)
      {
         return false;
      }

      if (obj == null && grab.getTarget() != null)
      {
         grab.setTarget (null);
         return true;
      }
      else if (obj != null && grab.getTarget() != obj.getJComponent())
      {
         grab.setTarget (obj.getJComponent());
         return true;
      }
      return false;
   }


   /**
    * get the target of the grab as FSAObject.
    *
    * @return   FSAObject of target, or null if target has no FSAObject
    * @see      de.uni_paderborn.fujaba.fsa.swing.JGrab#setTarget
    */
   public FSAObject getTarget()
   {
      JGrab grab = (JGrab) getJComponent();

      if (grab == null)
      {
         return null;
      }
      JComponent target = grab.getTarget();
      if (target != null)
      {
         return getFSAObjectFromJComponent (target);
      }
      else
      {
         return null;
      }
   }


   /**
    * @param point  No description provided
    * @deprecated   kept to load old fprs
    */
   protected void oldInitLocation (Point point)
   {
      if (point != null)
      {
         JGrab jgrab = (JGrab) getJComponent();
         if (point.getY() < 4)
         {
            jgrab.setAutoAlignment (false);
            jgrab.setAutoOrientation (false);
            jgrab.setAlignment (point.getX() / Integer.MAX_VALUE);
            switch ((int) point.getY())
            {
               case 0:
                  jgrab.setOrientation (Direction.TOP);
                  break;
               case 1:
                  jgrab.setOrientation (Direction.RIGHT);
                  break;
               case 2:
                  jgrab.setOrientation (Direction.BOTTOM);
                  break;
               case 3:
                  jgrab.setOrientation (Direction.LEFT);
                  break;
            }
         }
      }
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void applyProperties()
   {
      //TODO remove this code, kept only to load old fprs
      Point point = getPointFromUnparseInformation (LOCATION);
      //for loading older fprs:
      if (point == null && getLogic() instanceof ASGElement)
      {
         ASGElement asgElement = (ASGElement) getLogic();
         point = asgElement.getPointFromUnparseInformation (asgElement, getPropertyName());
      }

      if (point != null)
      {
         oldInitLocation (point);
      }
      //TODO-END
      else
      {
         // don't apply properties to parents, because
         // information stored there (location and dimension)
         // won't be used in FSAGrab
         //super.applyProperties();

         JGrab jgrab = (JGrab) getJComponent();
         String alignment = getUnparseInformation (ALIGNMENT);
         String orientation = getUnparseInformation (ORIENTATION);

         if (alignment == null)
         {
            jgrab.setAutoAlignment (true);
         }
         else
         {
            try
            {
               jgrab.setAlignment (Double.parseDouble (alignment));
               // is automatically done in setAlignment(double)
               //jgrab.setAutoAlignment (false);

//               // make shure data will be stored again
//               this.setTransientProperties (false);
            }
            catch (NumberFormatException e)
            {
               e.printStackTrace();
            }
         }

         if (orientation == null)
         {
            jgrab.setAutoOrientation (true);
         }
         else
         {
            try
            {
               switch (Integer.parseInt (orientation))
               {
                  case 0:
                     jgrab.setOrientation (Direction.TOP);
                     break;
                  case 1:
                     jgrab.setOrientation (Direction.RIGHT);
                     break;
                  case 2:
                     jgrab.setOrientation (Direction.BOTTOM);
                     break;
                  case 3:
                     jgrab.setOrientation (Direction.LEFT);
                     break;
               }
               // is automatically done in setOrientation(Direction)
               //jgrab.setAutoOrientation (false);

//               // make shure data will be stored again
//               this.setTransientProperties (false);
            }
            catch (NumberFormatException e)
            {
               e.printStackTrace();
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void saveLocation()
   {
      // do not save any location-information for a grab
   }


   /**
    * Saves the following additional properties:
    *   alignment:double,
    *   orientation:integer
    */
   protected void saveAdditionalFSAProperties()
   {
      saveAlignment();
      saveOrientation();
   }


   /**
    * Saves the 'collapsed' information of this FSAGrab object.
    */
   public void saveAlignment()
   {
      JGrab jGrab = (JGrab) getJComponent();

      if (jGrab == null)
      {
         return;
      }

      if (jGrab.isAutoAlignment())
      {
         removeFromUnparseInformation (ALIGNMENT);
      }
      else
      {
         addUnparseInformation (ALIGNMENT, Double.toString (jGrab.getAlignment()));
      }
   }


   /**
    * Saves the 'orientation' information of this FSAGrab object.
    */
   public void saveOrientation()
   {
      JGrab jGrab = (JGrab) getJComponent();

      if (jGrab == null)
      {
         return;
      }

      if (jGrab.isAutoOrientation())
      {
         removeFromUnparseInformation (ORIENTATION);
      }
      else
      {
         addUnparseInformation (ORIENTATION, Integer.toString (jGrab.getOrientation().asInt()));
      }
   }

}

/*
 * $Log: FSAGrab.java,v $
 * Revision 1.19.2.2  2005/05/30 15:31:14  fklar
 * removed setTransientProperties-call  in applyProperties() ... is done in FSAObject
 *
 */
