/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * Class FSALine
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.20 $
 */
public class FSALine
    extends FSAContainer
{
   /**
    * Constructor for class FSALine
    *
    * @param incr      No description provided
    * @param propName  No description provided
    */
   public FSALine (LogicUnparseInterface incr, String propName)
   {
      super (incr, propName);
   }


   /**
    * Constructor for class FSALine
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSALine (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Constructor for class FSALine
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    * @param comp      No description provided
    */
   public FSALine (LogicUnparseInterface incr, String propName, JComponent parent, JComponent comp)
   {
      super (incr, propName, parent, comp);
   }


   /**
    * create empty JPolyLine
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      // create empty JBendLine
      JBendLine line = new JBendLine (new Point (0, 0), new Point (0, 0));
      line.setBackground (FSAObject.COLOR_BACKGROUND);
      line.setForeground (FSAObject.COLOR_FOREGROUND);
      line.setLayout (new DecoratorLayout());
      return  (line);
   }


   /**
    * Sets the startPoint attribute of the FSALine object
    *
    * @param pos  The new startPoint value
    */
   public void setStartPoint (Point pos)
   {
       ((JLine) getJComponent()).setStartPoint (pos);
   }


   /**
    * Get the startPoint attribute of the FSALine object
    *
    * @return   The startPoint value
    */
   public Point getStartPoint()
   {
      JLine line = (JLine) getJComponent();

      return  (line != null) ? line.getStartPoint() : null;
   }


   /**
    * Sets the endPoint attribute of the FSALine object
    *
    * @param pos  The new endPoint value
    */
   public void setEndPoint (Point pos)
   {
       ((JLine) getJComponent()).setEndPoint (pos);
   }


   /**
    * Get the endPoint attribute of the FSALine object
    *
    * @return   The endPoint value
    */
   public Point getEndPoint()
   {
      JLine line = (JLine) getJComponent();

      return  (line != null) ? line.getEndPoint() : null;
   }

   /*
    *  public void recurseMouseEvent (MouseEvent event)
    *  {
    *  if (!isMouseReactable ())
    *  {
    *  FSAContainer container = (FSAContainer) getParent ();
    *  if (container != null)
    *  container.recurseMouseEvent (event);
    *  }
    *  else if (lineMouseListener != null)
    *  {
    *  int id = event.getID ();
    *  switch (id)
    *  {
    *  case MouseEvent.MOUSE_PRESSED:
    *  lineMouseListener.mousePressed (event);
    *  break;
    *  case MouseEvent.MOUSE_RELEASED:
    *  lineMouseListener.mouseReleased (event);
    *  break;
    *  case MouseEvent.MOUSE_CLICKED:
    *  lineMouseListener.mouseClicked (event);
    *  break;
    *  case MouseEvent.MOUSE_EXITED:
    *  lineMouseListener.mouseExited (event);
    *  break;
    *  case MouseEvent.MOUSE_ENTERED:
    *  lineMouseListener.mouseEntered (event);
    *  break;
    *  case MouseEvent.MOUSE_MOVED:
    *  lineMouseListener.mouseMoved (event);
    *  break;
    *  case MouseEvent.MOUSE_DRAGGED:
    *  lineMouseListener.mouseDragged (event);
    *  break;
    *  }
    *  }
    *  }
    */
}

/*
 * $Log: FSALine.java,v $
 * Revision 1.20  2004/11/03 10:17:52  lowende
 * Javadoc warnings removed.
 *
 */
