/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * FSAResizeable.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.19.2.1 $
 */
public class FSAResizeable extends FSAPanel
{
   /**
    * Calls the constructor FSAPanel(incr, propName, parent) with propName = parent = null.
    *
    * @param incr  No description provided
    */
   public FSAResizeable (LogicUnparseInterface incr)
   {
      super (incr, null, null);
   }


   /**
    * Calls the constructor FSAPanel(incr, propName, parent) with propName = null.
    *
    * @param incr    No description provided
    * @param parent  No description provided
    */
   public FSAResizeable (LogicUnparseInterface incr, JComponent parent)
   {
      super (incr, null, parent);
   }


   /**
    * Inherited constructor from FSAPanel.
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSAResizeable (LogicUnparseInterface incr,
                         String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Overwrites the constructor of FSAPanel.
    *
    * @param incr                 No description provided
    * @param propName             No description provided
    * @param parent               No description provided
    * @param transientProperties  No description provided
    */
   public FSAResizeable (LogicUnparseInterface incr,
                         String propName, JComponent parent, boolean transientProperties)
   {
      super (incr, propName, parent, transientProperties);
   }

   // --- [Resizing support]----------------------------------------------------

   /**
    * Sets the minimum size of this object. Usually this method will be called after the unparse
    * module has constructed the complete display structure.
    *
    * @param size  The new minimumSize value
    */
   public void setMinimumSize (Dimension size)
   {
      JComponent comp = getJComponent();

      if (comp != null)
      {
         comp.setMinimumSize (size);
      }
   }


   /**
    * Return minimum size of the component.
    *
    * @return   The minimumSize value
    */
   public Dimension getMinimumSize()
   {
      Dimension size = null;
      JComponent comp = getJComponent();

      if (comp != null)
      {
         size = comp.getMinimumSize();
      }

      return size;
   }


   /**
    * Sets the maximum size of this object.
    *
    * @param size  The new maximumSize value
    */
   public void setMaximumSize (Dimension size)
   {
      JComponent comp = getJComponent();

      if (comp != null)
      {
         comp.setMaximumSize (size);
      }
   }


   /**
    * Return maximum size of the component.
    *
    * @return   The maximumSize value
    */
   public Dimension getMaximumSize()
   {
      Dimension size = null;
      JComponent comp = getJComponent();

      if (comp != null)
      {
         size = comp.getMaximumSize();
      }

      return size;
   }


   /**
    * Set size of the JComponent.
    *
    * @param size  The new size value
    */
   public void setSize (Dimension size)
   {
      JComponent comp = getJComponent();

      if (comp != null)
      {
         comp.setSize (size);
         comp.setPreferredSize (size);

         comp.invalidate();
         comp.revalidate();
         comp.repaint();
      }
   }


   /**
    * Return size of the component.
    *
    * @return   The size value
    */
   public Dimension getSize()
   {
      return getJComponent().getSize();
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Dimension userSize = null;


   /**
    * Set size of this component which is set during resizing by the user
    *
    * @param size  The new userSize value
    */
   public void setUserSize (Dimension size)
   {
      if ( (this.userSize == null) || ! (this.userSize.equals (size)))
      {
         this.userSize = size;
      }

      setSize (this.userSize);
   }


   /**
    * Get the size of this component set by the user
    *
    * @return   The userSize value
    */
   public Dimension getUserSize()
   {
      Dimension size;

      if (this.userSize == null)
      {
         size = getPreferredSize();
      }
      else
      {
         size = this.userSize;
      }

      return size;
   }


   /**
    * Reset the size of this component to the ui calculated size
    *
    * @param size  The new preferredSize value
    */
   public void setPreferredSize (Dimension size)
   {
      JComponent comp = getJComponent();

      if (comp != null)
      {
         comp.setPreferredSize (size);
      }
   }


   /**
    * Return the preferred size of the component
    *
    * @return   The preferredSize value
    */
   public Dimension getPreferredSize()
   {
      return getJComponent().getPreferredSize();
   }


   /**
    * Resizes this component.
    *
    * @param dx  The amount to increase the width of this component.
    * @param dy  The amount to increase the height of this component.
    */
   public void resize (int dx, int dy)
   {
      JComponent comp = getJComponent();

      if (comp != null)
      {
         Dimension min = getMinimumSize();
         Dimension max = getMaximumSize();

         int width = comp.getWidth() + dx;
         int height = comp.getHeight() + dy;

         if ( (width < min.width) ||  (width > max.width))
         {
            if (width < min.width)
            {
               width = min.width;
            }
            else
            {
               width = max.width;
            }
         }

         if ( (height < min.height) ||  (height > max.height))
         {
            if (height < min.height)
            {
               height = min.height;
            }
            else
            {
               height = max.height;
            }
         }

         setUserSize (new Dimension (width, height));
      }
   }

}

/*
 * $Log: FSAResizeable.java,v $
 * Revision 1.19.2.1  2005/05/30 15:31:59  fklar
 * introduced new constructor that takes transientProperties as argument
 *
 */
