/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.swing.JExtendedSeparator;
import de.uni_paderborn.fujaba.fsa.swing.JSeparatedPanel;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * FSA component for a separated panel.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.12.2.1 $
 */
public class FSASeparatedPanel extends FSAPanel
{
   /**
    * Overwrites the constructor of FSAPanel.
    *
    * @param incr  No description provided
    */
   public FSASeparatedPanel (LogicUnparseInterface incr)
   {
      this (incr, "separator", null);
   }


   /**
    * Overwrites the constructor of FSAPanel.
    *
    * @param incr    No description provided
    * @param parent  No description provided
    */
   public FSASeparatedPanel (LogicUnparseInterface incr, JComponent parent)
   {
      this (incr, "separator", parent);
   }


   /**
    * Overwrites the constructor of FSAPanel.
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSASeparatedPanel (LogicUnparseInterface incr,
                             String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Overwrites the constructor of FSAPanel.
    *
    * @param incr                 No description provided
    * @param propName             No description provided
    * @param parent               No description provided
    * @param transientProperties  No description provided
    */
   public FSASeparatedPanel (LogicUnparseInterface incr,
                             String propName, JComponent parent, boolean transientProperties)
   {
      super (incr, propName, parent, transientProperties);
   }


   /**
    * Creates a JSeparatedPanel as inner component.
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JSeparatedPanel panel = new JSeparatedPanel();
      panel.setBackground (FSAObject.COLOR_BACKGROUND);
      panel.setForeground (FSAObject.COLOR_FOREGROUND);
      return  (panel);
   }


   /**
    * Add a separator to the end of the components.
    */
   public void addSeparator()
   {
      JSeparatedPanel panel = (JSeparatedPanel) getJComponent();
      panel.addSeparator();
   }


   /**
    * Get the lastSeparator attribute of the FSASeparatedPanel object
    *
    * @return   The lastSeparator value
    */
   public JExtendedSeparator getLastSeparator()
   {
      JSeparatedPanel panel = (JSeparatedPanel) getJComponent();
      return panel.getLastSeparator();
   }

}

/*
 * $Log: FSASeparatedPanel.java,v $
 * Revision 1.12.2.1  2005/05/30 15:31:59  fklar
 * introduced new constructor that takes transientProperties as argument
 *
 */
