/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.awt.event.InputMethodListener;
import java.util.*;

import javax.swing.*;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.uni_paderborn.fujaba.fsa.listener.EditableComponentListener;
import de.uni_paderborn.fujaba.fsa.swing.JTextEditor;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.TextComponentUpdater;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.16 $
 */
public class FSATextComponent extends FSAObject
{
   /**
    * Constructor for class FSATextComponent
    *
    * @param incr      No description provided
    * @param propName  No description provided
    */
   public FSATextComponent (LogicUnparseInterface incr, String propName)
   {
      super (incr, propName);
   }


   /**
    * Constructor for class FSATextComponent
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSATextComponent (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Constructor for class FSATextComponent
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    * @param comp      No description provided
    */
   public FSATextComponent (LogicUnparseInterface incr, String propName, JComponent parent, JComponent comp)
   {
      super (incr, propName, parent, comp);
   }


   /**
    * Get the defaultUpdaterClass attribute of the FSATextComponent object
    *
    * @return   The defaultUpdaterClass value
    */
   public Class getDefaultUpdaterClass()
   {
      return TextComponentUpdater.class;
   }


   /**
    * Get the defaultAttrName attribute of the FSATextComponent object
    *
    * @return   The defaultAttrName value
    */
   public String getDefaultAttrName()
   {
      return "text";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JTextEditor txt = new JTextEditor();
      AscendDescendMouseHandler.addMouseListener (txt,
         EditableComponentListener.get());
      txt.setBackground (COLOR_BACKGROUND);
      txt.setForeground (COLOR_FOREGROUND);
      return  (txt);
   }


   /**
    * Set the Text of the current document to text and reset contentsChanged
    *
    * @param text  The new text value
    * @see         #getText ()
    * @see         #setDocument (Document)
    */
   public void setText (String text)
   {
      JTextEditor pane = (JTextEditor) getJComponent();
      pane.setText (text);
      pane.invalidate();
   }


   /**
    * Get the Text of the current Docuemnt
    *
    * @return   The text value
    * @see      #setText (String)
    * @see      #getDocument ()
    */
   public String getText()
   {
      JTextEditor pane = (JTextEditor) getJComponent();

      if (pane != null)
      {
         return pane.getText();
      }
      return null;
   }


   /**
    * Set doc as the current document and reset contentsChanged
    *
    * @param doc  The new document value
    * @see        #getDocument ()
    * @see        #setText (String)
    */
   public void setDocument (Document doc)
   {
      JTextEditor pane = (JTextEditor) getJComponent();
      pane.setDocument (doc);
      pane.invalidate();
   }


   /**
    * Get the current Document
    *
    * @return   The document value
    * @see      #getText ()
    * @see      #setDocument (Document)
    */
   public Document getDocument()
   {
      JTextComponent pane = (JTextComponent) getJComponent();

      if (pane != null)
      {
         return pane.getDocument();
      }
      return null;
   }


   /**
    * Access method for an one to n association.
    *
    * @param listener  The object added.
    */
   public void addCaretListener (CaretListener listener)
   {
      JTextComponent textComponent = (JTextComponent) getJComponent();
      textComponent.addCaretListener (listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param listener  No description provided
    */
   public void removeCaretListener (CaretListener listener)
   {
      JTextComponent textComponent = (JTextComponent) getJComponent();
      textComponent.removeCaretListener (listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfCaretListeners()
   {
      EventListener[] listeners = getJComponent().getListeners (CaretListener.class);
      return Arrays.asList (listeners).iterator();
   }


   /**
    * Access method for an one to n association.
    *
    * @param listener  The object added.
    */
   public void addInputMethodListener (InputMethodListener listener)
   {
      JTextComponent textComponent = (JTextComponent) getJComponent();
      textComponent.addInputMethodListener (listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param listener  No description provided
    */
   public void removeInputMethodListener (InputMethodListener listener)
   {
      JTextComponent textComponent = (JTextComponent) getJComponent();
      textComponent.removeInputMethodListener (listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfInputMethodListeners()
   {
      EventListener[] listeners = getJComponent().getListeners (InputMethodListener.class);
      return Arrays.asList (listeners).iterator();
   }
}

/*
 * $Log: FSATextComponent.java,v $
 * Revision 1.16  2004/10/20 17:49:41  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
