/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.actions;

import java.awt.*;
import java.awt.event.ActionEvent;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JPolyLine;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.lib.userinterface.UserInterfaceManager;


/**
 * @author    $Author: fklar $
 * @version   $Revision: 1.14.2.3 $
 */
public class AddBendAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {
      FSAObject[] selected = SelectionManager.get().getLastSelectionsOfType (FSAPolyLine.class, 1);

      if (selected.length > 0)
      {
         FSAPolyLine selectedLine = (FSAPolyLine) selected[0];
         JPolyLine polyLine = (JPolyLine) selectedLine.getJComponent();

         Point cursorPosition = UserInterfaceManager.get().getLastPointerPosition();
         cursorPosition.translate (polyLine.getX(), polyLine.getY());
         FSABend bend = newBend (selectedLine, cursorPosition);
         polyLine.insertInBends ((JBend) bend.getJComponent());

         selectedLine.setTransientProperties (false);
         selectedLine.saveAdditionalBendLocation();

         // select the bend and nothing else
         SelectionManager.get().setSelected (bend, true, false);
      }

      UMLProject.get().refreshDisplay();
   }


   /**
    * Creates a new <code>FSABend</code> that is attached to
    * <code>selectedLine</code>.
    *
    * @param selectedLine  The <code>FSAPolyLine</code> object the new
    * 						<code>FSABend</code> should be attached to.
    * @param point         The x/y-coordinates the new bend should be positioned.
    * @return              A new <code>FSABend</code>.
    */
   public static FSABend newBend (FSAPolyLine selectedLine, Point point)
   {
      JPolyLine polyLine = (JPolyLine) selectedLine.getJComponent();

      FSABend bend = new FSABend (selectedLine.getLogic(), null, (JComponent) polyLine.getParent());
      bend.getJComponent().setVisible (false);
      // we do't have to save 'additional bend' properties, because
      // the one and only required information (location of bend)
      // is stored in the poly-line
      //bend.setTransientProperties (true);

      SelectionListenerHelper.addSelectionListener (bend.getJComponent(), ForegroundHighlighter.get());
      SelectionListenerHelper.addSelectionListener (bend.getJComponent(), VisibilityHighlighter.get());

      // moved this call to AddBendAction#actionPerformed-function,
      // because it causes many other function-calls
      // like FSAPolyLine#saveLocation() and FSAPolyLine#initFSAProperties
      // this leads to recursive calls, because
      // FSAPolyLine#initFSAProperties calls AddBendAction#newBend, too
      // and though important UnparseInformation (like additional bends)
      // will be overwritten
      //SelectionManager.get().setSelected (bend, true, true);

      AscendDescendMouseHandler.addMouseInputListener (bend.getJComponent(), SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (bend.getJComponent(), DragMouseListener.get());
//          bend.getJComponent().addMouseListener(SelectionMouseListener.get());
//          bend.getJComponent().addMouseMotionListener(SelectionMouseListener.get());
//          bend.getJComponent().addMouseListener(DragMouseListener.get());
//          bend.getJComponent().addMouseMotionListener(DragMouseListener.get());

      bend.setPoint (point);

      return bend;
   }
}

/*
 * $Log: AddBendAction.java,v $
 * Revision 1.14.2.3  2005/05/30 15:07:18  fklar
 * + after creating a new bend it will be selected and nothing else
 * + properties of additional bends won't be saved (they are stored in the polyline)
 *
 */
