/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.AbstractAction;

import de.uni_paderborn.fujaba.fsa.FSABend;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSAPolyLine;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JPolyLine;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * This action deletes 'additional' bends from a polyline.
 * It is the inverse action of 'AddBendAction'.
 * Start and end-bends won't be deleted, because the line
 * would be corrupted otherwise.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.12.2.2 $
 */
public class DeleteBendAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {
      FSAObject[] selected = SelectionManager.get().getLastSelectionsOfType (FSABend.class);

      // nothing to do if no bends are selected
      if (selected.length == 0)
      {
         return;
      }

      FSABend bend;
      JBend jBend;
      Iterator lines;
      JBendLine line;
      JPolyLine.LineSegment segment;
      FSAPolyLine polyLine;
      JPolyLine jPolyLine;

      for (int i = 0; i < selected.length; i++)
      {
         boolean keepFSABend = false;

         bend = (FSABend) selected[i];
         jBend = (JBend) bend.getJComponent();

         lines = jBend.iteratorOfLines();
         while (lines.hasNext())
         {
            line = (JBendLine) lines.next();

            // delete 'additional' bends of a polyline
            if (line instanceof JPolyLine.LineSegment)
            {
               segment = (JPolyLine.LineSegment) line;
               jPolyLine = segment.getPolyLine();

               if (jBend == jPolyLine.getStartBend()
                  || jBend == jPolyLine.getEndBend())
               {
                  // don't delete start or end-bends
                  // graphical representation will
                  // be corrupted otherwise
                  keepFSABend = true;
                  continue;
               }

               if (jPolyLine != null)
               {
                  jPolyLine.removeFromBends (jBend);

                  // make shure new number of bends will be saved
                  // so if diagram is closed and reopened
                  // the deleted bend won't re-appear
                  polyLine = (FSAPolyLine) FSAObject.getFSAObjectFromJComponent (jPolyLine);

                  polyLine.clearAdditionalBendLocation();
                  polyLine.saveAdditionalBendLocation();
               }
               else
               {
                  // if the bend of a line-segment is deleted,
                  // we have to delete the whole line-segment.
                  // A line-segment with just one bend
                  // doesn't seem to make sense! right?
                  segment.removeYou();
                  //segment.setStartBend(null);
               }
            }
            else if (line instanceof JPolyLine)
            {
               jPolyLine = (JPolyLine) line;

               if (jBend == jPolyLine.getStartBend()
                  || jBend == jPolyLine.getEndBend())
               {
                  // don't delete start or end-bends
                  // graphical representation will
                  // be corrupted otherwise
                  keepFSABend = true;
                  continue;
               }

            }
            // delete 'normal' bends
            else
            {
               // NOTE: remember not to allow deletion of normal
               // bends that are start/end-points of a line
               // from userinterface,
               // otherwise graphical representation will be corrupted
               //line.setEndBend(null);

               // don't delete bend from bendline
               // otherwise bendline won't have start- or end-point
               keepFSABend = true;
               continue;
            }
         }

         // should graphical representation be kept?
         // e.g. if
         if (!keepFSABend)
         {
            bend.removeYou();
         }
      }

      UMLProject.get().refreshDisplay();
   }
}

/*
 * $Log: DeleteBendAction.java,v $
 * Revision 1.12.2.2  2005/05/25 12:50:20  fklar
 * updating location-information in FSAPolyLine after deleting an additional bend
 *
 */
