/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.*;
import java.lang.ref.WeakReference;
import java.util.*;
import java.util.List;

import javax.swing.event.MouseInputListener;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.13 $
 */
public class AscendDescendMouseHandler implements MouseInputListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final WeakReference target;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean active = false;


   /*
    *  package
    */
   /**
    * Constructor for class AscendDescendMouseHandler
    *
    * @param target  No description provided
    */
   AscendDescendMouseHandler (Component target)
   {
      this.target = new WeakReference (target);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private EventListener listener;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private EventListener ascendListener;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private EventListener descendListener;


   /**
    * Adds the specified mouse motion listener to receive mouse motion events from this component.
    * If l is null, no exception is thrown and no action is performed.
    *
    * @param l  the mouse motion listener.
    * @see      java.awt.event.MouseEvent
    * @see      java.awt.event.MouseListener
    * @see      #removeMouseListener(Component, MouseListener)
    * @see      java.awt.Component#addMouseListener
    */
   public synchronized void addMouseListener (MouseListener l)
   {
      if (l == null)
      {
         return;
      }
      if (!active)
      {
         Component comp = (Component) target.get();
         if (comp != null)
         {
            comp.addMouseListener (this);
            active = true;
         }
      }
      boolean isAD = false;
      if (l instanceof Ascend)
      {
         ascendListener = AWTEventMulticaster.add ((MouseListener) ascendListener, l);
         isAD = true;
      }
      if (l instanceof Descend)
      {
         descendListener = AWTEventMulticaster.add ((MouseListener) descendListener, l);
         isAD = true;
      }
      if (!isAD)
      {
         listener = AWTEventMulticaster.add ((MouseListener) listener, l);
      }
   }


   /**
    * Adds the specified mouse motion listener to receive mouse motion events from this component.
    * If l is null, no exception is thrown and no action is performed.
    *
    * @param l  the mouse motion listener.
    * @see      java.awt.event.MouseEvent
    * @see      java.awt.event.MouseMotionListener
    * @see      #removeMouseMotionListener(MouseMotionListener)
    * @see      java.awt.Component#addMouseMotionListener
    */
   public synchronized void addMouseMotionListener (MouseMotionListener l)
   {
      if (l == null)
      {
         return;
      }
      if (!active)
      {
         Component comp = (Component) target.get();
         if (comp != null)
         {
            comp.addMouseMotionListener (this);
            active = true;
         }
      }
      boolean isAD = false;
      if (l instanceof Ascend)
      {
         ascendListener = AWTEventMulticaster.add ((MouseMotionListener) ascendListener, l);
         isAD = true;
      }
      if (l instanceof Descend)
      {
         descendListener = AWTEventMulticaster.add ((MouseMotionListener) descendListener, l);
         isAD = true;
      }
      if (!isAD)
      {
         listener = AWTEventMulticaster.add ((MouseMotionListener) listener, l);
      }
   }


   /**
    * Removes the specified mouse listener so that it no longer receives mouse events from
    * this component. This method performs no function, nor does it throw an exception, if
    * the listener specified by the argument was not previously added to this component. If
    * l is null, no exception is thrown and no action is performed.
    *
    * @param l  the mouse listener.
    * @see      java.awt.event.MouseEvent
    * @see      java.awt.event.MouseListener
    * @see      #addMouseListener(MouseListener)
    * @see      java.awt.Component#removeMouseListener
    */
   public synchronized void removeMouseListener (MouseListener l)
   {
      if (l == null)
      {
         return;
      }
      boolean isAD = false;
      if (l instanceof Ascend)
      {
         ascendListener = AWTEventMulticaster.remove ((MouseListener) ascendListener, l);
         isAD = true;
      }
      if (l instanceof Descend)
      {
         descendListener = AWTEventMulticaster.remove ((MouseListener) descendListener, l);
         isAD = true;
      }
      if (!isAD)
      {
         listener = AWTEventMulticaster.remove ((MouseListener) listener, l);
      }
      if (active && ascendListener == null && descendListener == null && listener == null)
      {
         Component comp = (Component) target.get();
         if (comp != null)
         {
            comp.removeMouseListener (this);
            comp.removeMouseMotionListener (this);
            active = false;
         }
      }
   }


   /**
    * Removes the specified mouse listener so that it no longer receives mouse events from
    * this component. This method performs no function, nor does it throw an exception, if
    * the listener specified by the argument was not previously added to this component. If
    * l is null, no exception is thrown and no action is performed.
    *
    * @param l  the mouse listener.
    * @see      java.awt.event.MouseEvent
    * @see      java.awt.event.MouseMotionListener
    * @see      #addMouseMotionListener(MouseMotionListener)
    * @see      java.awt.Component#removeMouseMotionListener
    */
   public synchronized void removeMouseMotionListener (MouseMotionListener l)
   {
      if (l == null)
      {
         return;
      }
      boolean isAD = false;
      if (l instanceof Ascend)
      {
         ascendListener = AWTEventMulticaster.remove ((MouseMotionListener) ascendListener, l);
         isAD = true;
      }
      if (l instanceof Descend)
      {
         descendListener = AWTEventMulticaster.remove ((MouseMotionListener) descendListener, l);
         isAD = true;
      }
      if (!isAD)
      {
         listener = AWTEventMulticaster.remove ((MouseMotionListener) listener, l);
      }
      if (active && ascendListener == null && descendListener == null && listener == null)
      {
         Component comp = (Component) target.get();
         if (comp != null)
         {
            comp.removeMouseListener (this);
            comp.removeMouseMotionListener (this);
            active = false;
         }
      }
   }


   /**
    * Get the ascendListener attribute of the AscendDescendMouseHandler object
    *
    * @return   The ascendListener value
    */
   public EventListener getAscendListener()
   {
      return this.ascendListener;
   }


   /**
    * Get the descendListener attribute of the AscendDescendMouseHandler object
    *
    * @return   The descendListener value
    */
   public EventListener getDescendListener()
   {
      return this.descendListener;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mousePressed (MouseEvent e)
   {
      dispatchEvent (e, (MouseListener) listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseReleased (MouseEvent e)
   {
      dispatchEvent (e, (MouseListener) listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseClicked (MouseEvent e)
   {
      dispatchEvent (e, (MouseListener) listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseEntered (MouseEvent e)
   {
      dispatchEvent (e, (MouseListener) listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseExited (MouseEvent e)
   {
      dispatchEvent (e, (MouseListener) listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseMoved (MouseEvent e)
   {
      dispatchEvent (e, (MouseMotionListener) listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseDragged (MouseEvent e)
   {
      dispatchEvent (e, (MouseMotionListener) listener);
   }

   // ----------------------------------------------------------------------------------------
   // -------------------------- end of instance methods -------------------------------------
   // ----------------------------------------------------------------------------------------

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param component  No description provided
    */
   public static void registerADMouseHandler (Component component)
   {
      if (component != null)
      {
         MouseListener[] listeners = (MouseListener[]) component.getListeners (MouseListener.class);
         AscendDescendMouseHandler handler = getHandler (listeners);
         if (handler == null)
         {
            handler = getADHandler();
            component.addMouseListener (handler);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param component  No description provided
    */
   public static void registerADMouseMotionHandler (Component component)
   {
      if (component != null)
      {
         MouseMotionListener[] listeners = (MouseMotionListener[]) component.getListeners (MouseMotionListener.class);
         AscendDescendMouseHandler handler = getHandler (listeners);
         if (handler == null)
         {
            handler = getADHandler();
            component.addMouseMotionListener (handler);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param component  No description provided
    */
   public static void unregisterADMouseHandler (Component component)
   {
      if (component != null)
      {
         component.removeMouseListener (getADHandler());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param component  No description provided
    */
   public static void unregisterADMouseMotionHandler (Component component)
   {
      if (component != null)
      {
         component.removeMouseMotionListener (getADHandler());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param component  No description provided
    */
   public static void registerADMouseInputHandler (Component component)
   {
      registerADMouseHandler (component);
      registerADMouseMotionHandler (component);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param component  No description provided
    */
   public static void unregisterADMouseInputHandler (Component component)
   {
      unregisterADMouseHandler (component);
      unregisterADMouseMotionHandler (component);
   }


   /**
    * Access method for an one to n association.
    *
    * @param component  The object added.
    * @param listener   The object added.
    */
   public static void addMouseListener (Component component, MouseListener listener)
   {
      if (component != null && listener != null)
      {
         MouseListener[] listeners = (MouseListener[]) component.getListeners (MouseListener.class);
         AscendDescendMouseHandler handler = getHandler (listeners);
         if (handler == getADHandler())
         {
            component.removeMouseListener (handler);
            handler = null;
         }
         if (handler == null)
         {
            handler = new AscendDescendMouseHandler (component);
            registerADMouseMotionHandler (component);
         }
         handler.addMouseListener (listener);
      }
   }


   /**
    * Access method for an one to n association.
    *
    * @param component  The object added.
    * @param listener   The object added.
    */
   public static void addMouseMotionListener (Component component, MouseMotionListener listener)
   {
      if (component != null && listener != null)
      {
         MouseMotionListener[] listeners = (MouseMotionListener[]) component.getListeners (MouseMotionListener.class);
         AscendDescendMouseHandler handler = getHandler (listeners);
         if (handler == getADHandler())
         {
            component.removeMouseMotionListener (handler);
            handler = null;
         }
         if (handler == null)
         {
            handler = new AscendDescendMouseHandler (component);
            registerADMouseHandler (component);
         }
         handler.addMouseMotionListener (listener);
      }
   }


   /**
    * Access method for an one to n association.
    *
    * @param component  The object added.
    * @param listener   The object added.
    */
   public static void addMouseInputListener (Component component, MouseInputListener listener)
   {
      addMouseListener (component, listener);
      addMouseMotionListener (component, listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param component  No description provided
    * @param listener   No description provided
    */
   public static void removeMouseListener (Component component, MouseListener listener)
   {
      if (component != null && listener != null)
      {
         component.removeMouseListener (listener);
         MouseListener[] listeners = (MouseListener[]) component.getListeners (MouseListener.class);
         for (int i = 0; i < listeners.length; i++)
         {
            if (listeners[i] instanceof AscendDescendMouseHandler)
            {
                ((AscendDescendMouseHandler) listeners[i]).removeMouseListener (listener);
            }
         } // for
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param component  No description provided
    * @param listener   No description provided
    */
   public static void removeMouseMotionListener (Component component, MouseMotionListener listener)
   {
      if (component != null && listener != null)
      {
         component.removeMouseMotionListener (listener);
         MouseMotionListener[] listeners = (MouseMotionListener[]) component.getListeners (MouseMotionListener.class);
         for (int i = 0; i < listeners.length; i++)
         {
            if (listeners[i] instanceof AscendDescendMouseHandler)
            {
                ((AscendDescendMouseHandler) listeners[i]).removeMouseMotionListener (listener);
            }
         } // for
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param component  No description provided
    * @param listener   No description provided
    */
   public static void removeMouseInputListener (Component component, MouseInputListener listener)
   {
      removeMouseListener (component, listener);
      removeMouseMotionListener (component, listener);
   }


   /**
    * Get the handler attribute of the AscendDescendMouseHandler class
    *
    * @param listeners  No description provided
    * @return           The handler value
    */
   private static AscendDescendMouseHandler getHandler (EventListener[] listeners)
   {
      for (int i = 0; i < listeners.length; i++)
      {
         if (listeners[i] instanceof AscendDescendMouseHandler)
         {
            return (AscendDescendMouseHandler) listeners[i];
         }
      } // for
      return null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param component  No description provided
    */
   public static void claimMouseListeners (Component component)
   {
      MouseListener[] listeners = (MouseListener[]) component.getListeners (MouseListener.class);
      if (listeners.length > 0)
      {
         AscendDescendMouseHandler handler = getHandler (listeners);
         if (handler == getADHandler())
         {
            component.removeMouseListener (handler);
            handler = null;
         }
         if (handler == null)
         {
            handler = new AscendDescendMouseHandler (component);
            component.addMouseListener (handler);
            registerADMouseMotionHandler (component);
         }
         for (int i = 0; i < listeners.length; i++)
         {
            if (listeners[i] != handler && listeners[i] != getADHandler())
            {
               component.removeMouseListener (listeners[i]);
               handler.addMouseListener (listeners[i]);
            }
         } // for
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param component  No description provided
    */
   public static void claimMouseMotionListeners (Component component)
   {
      MouseMotionListener[] listeners = (MouseMotionListener[]) component.getListeners (MouseMotionListener.class);
      if (listeners.length > 0)
      {
         AscendDescendMouseHandler handler = getHandler (listeners);
         if (handler == getADHandler())
         {
            component.removeMouseMotionListener (handler);
            handler = null;
         }
         if (handler == null)
         {
            handler = new AscendDescendMouseHandler (component);
            component.addMouseMotionListener (handler);
            registerADMouseHandler (component);
         }
         for (int i = 0; i < listeners.length; i++)
         {
            if (listeners[i] != handler && listeners[i] != getADHandler())
            {
               component.removeMouseMotionListener (listeners[i]);
               handler.addMouseMotionListener (listeners[i]);
            }
         } // for
      }
   }


   /**
    * Get the aDInfo attribute of the AscendDescendMouseHandler class
    *
    * @param e        No description provided
    * @param ascend   No description provided
    * @param descend  No description provided
    */
   private static void getADInfo (MouseEvent e, LinkedList ascend, LinkedList descend)
   {
      int id = e.getID();
      boolean motionEvent =  (id == MouseEvent.MOUSE_MOVED || id == MouseEvent.MOUSE_DRAGGED);

      Component current = e.getComponent();
      int xOff = 0;
      int yOff = 0;

      EventListener[] listeners = null;

      while (current != null)
      {
         if (motionEvent)
         {
            listeners = current.getListeners (MouseMotionListener.class);
         }
         else
         {
            listeners = current.getListeners (MouseListener.class);
         } // else
         if (listeners.length > 0)
         {
            EventListener tmpListener;
            LinkedList ascendEntry = null;
            LinkedList descendEntry = null;

            for (int i = 0; i < listeners.length; i++)
            {
               tmpListener = listeners[i];
               if (tmpListener instanceof AscendDescendMouseHandler)
               {
                  AscendDescendMouseHandler handler = (AscendDescendMouseHandler) tmpListener;
                  tmpListener = handler.getAscendListener();
                  if (tmpListener != null)
                  {
                     if (ascendEntry == null)
                     {
                        ascendEntry = new LinkedList();
                        ascendEntry.add (current);
                        ascendEntry.add (new int[]{xOff, yOff});
                     }
                     ascendEntry.add (tmpListener);
                  }
                  tmpListener = handler.getDescendListener();
                  if (tmpListener != null)
                  {
                     if (descendEntry == null)
                     {
                        descendEntry = new LinkedList();
                        descendEntry.add (current);
                        descendEntry.add (new int[]{xOff, yOff});
                     }
                     descendEntry.add (tmpListener);
                  }
               }
               else
               {
                  if (tmpListener instanceof Ascend)
                  {
                     if (ascendEntry == null)
                     {
                        ascendEntry = new LinkedList();
                        ascendEntry.add (current);
                        ascendEntry.add (new int[]{xOff, yOff});
                     }
                     ascendEntry.add (tmpListener);
                  }
                  if (tmpListener instanceof Descend)
                  {
                     if (descendEntry == null)
                     {
                        descendEntry = new LinkedList();
                        descendEntry.add (current);
                        descendEntry.add (new int[]{xOff, yOff});
                     }
                     descendEntry.add (tmpListener);
                  }
               }
            } // for

            if (ascendEntry != null)
            {
               ascend.addFirst (ascendEntry);
            }
            if (descendEntry != null)
            {
               descend.add (descendEntry);
            }
         }

         xOff += current.getX();
         yOff += current.getY();
         current = current.getParent();
      } // while
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e           No description provided
    * @param comp        No description provided
    * @param realSource  No description provided
    * @param xOff        No description provided
    * @param yOff        No description provided
    * @param listeners   No description provided
    * @param ascend      No description provided
    * @return            No description provided
    */
   private static boolean dispatchEvent (MouseEvent e, Component comp, Component realSource, int xOff, int yOff,
                                         Iterator listeners, boolean ascend)
   {
      ADMouseEvent convertedEvent = cloneEvent (e, comp, realSource, xOff, yOff);
      convertedEvent.ascend = ascend;
      EventListener tmpListener;

      while (listeners.hasNext())
      {
         tmpListener = (EventListener) listeners.next();

         fireEvent (convertedEvent, tmpListener);
      } // while
      if (convertedEvent.isConsumed())
      {
         e.consume();
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e         No description provided
    * @param listener  No description provided
    */
   private static void fireEvent (MouseEvent e, EventListener listener)
   {
      int id = e.getID();
      switch (id)
      {
         case MouseEvent.MOUSE_PRESSED:
             ((MouseListener) listener).mousePressed (e);
            break;
         case MouseEvent.MOUSE_RELEASED:
             ((MouseListener) listener).mouseReleased (e);
            break;
         case MouseEvent.MOUSE_CLICKED:
             ((MouseListener) listener).mouseClicked (e);
            break;
         case MouseEvent.MOUSE_ENTERED:
             ((MouseListener) listener).mouseEntered (e);
            break;
         case MouseEvent.MOUSE_EXITED:
             ((MouseListener) listener).mouseExited (e);
            break;
         case MouseEvent.MOUSE_MOVED:
             ((MouseMotionListener) listener).mouseMoved (e);
            break;
         case MouseEvent.MOUSE_DRAGGED:
             ((MouseMotionListener) listener).mouseDragged (e);
            break;
      } // switch
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e               No description provided
    * @param sourceListener  No description provided
    */
   public static void dispatchEvent (MouseEvent e, MouseListener sourceListener)
   {
      dispatchEventImpl (e, sourceListener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e               No description provided
    * @param sourceListener  No description provided
    */
   public static void dispatchEvent (MouseEvent e, MouseMotionListener sourceListener)
   {
      dispatchEventImpl (e, sourceListener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e               No description provided
    * @param sourceListener  No description provided
    */
   private static void dispatchEventImpl (MouseEvent e, EventListener sourceListener)
   {
      LinkedList ascendList = new LinkedList();
      LinkedList descendList = new LinkedList();

      getADInfo (e, ascendList, descendList);

      int id = e.getID();

      boolean enterExit =  (id == MouseEvent.MOUSE_ENTERED || id == MouseEvent.MOUSE_EXITED);

      Component realSource = e.getComponent();

      boolean consumed = false;
      if (ascendList.size() > 0)
      {
         Iterator ascendIter = ascendList.iterator();
         while (ascendIter.hasNext())
         {
            List ascendStepList = (List) ascendIter.next(); //guaranteed to have > 2 elements
            Iterator stepIter = ascendStepList.iterator();
            Component source = (Component) stepIter.next();
            int[] offset = (int[]) stepIter.next();

            if (!enterExit ||  (offset[0] == 0 && offset[1] == 0))
            {
               consumed = dispatchEvent (e, source, realSource, offset[0], offset[1], stepIter, true);
            }

            if (consumed)
            {
               return;
            }
         } // while
      }
      if (sourceListener != null)
      {
         fireEvent (e, sourceListener);
         if (consumed)
         {
            return;
         }
      }
      if (descendList.size() > 0)
      {
         Iterator descendIter = descendList.iterator();
         while (descendIter.hasNext())
         {
            List descendStepList = (List) descendIter.next(); //guaranteed to have > 2 elements
            Iterator stepIter = descendStepList.iterator();
            Component source = (Component) stepIter.next();
            int[] offset = (int[]) stepIter.next();

            if (!enterExit ||  (offset[0] == 0 && offset[1] == 0))
            {
               consumed = dispatchEvent (e, source, realSource, offset[0], offset[1], stepIter, false);
            }

            if (consumed)
            {
               return;
            }
         } // while
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e           No description provided
    * @param source      No description provided
    * @param realSource  No description provided
    * @param xOff        No description provided
    * @param yOff        No description provided
    * @return            No description provided
    */
   private static ADMouseEvent cloneEvent (MouseEvent e, Component source, Component realSource, int xOff, int yOff)
   {
      return new ADMouseEvent (source, realSource, e.getID(), e.getWhen(), e.getModifiers(), e.getX() + xOff,
         e.getY() + yOff, e.getClickCount(), e.isPopupTrigger());
   }


   /**
    * Get the aDMouseEvent attribute of the AscendDescendMouseHandler class
    *
    * @param evt  No description provided
    * @return     The aDMouseEvent value
    */
   public static boolean isADMouseEvent (MouseEvent evt)
   {
      return  (evt instanceof ADMouseEvent);
   }


   /**
    * Get the ascendMouseEvent attribute of the AscendDescendMouseHandler class
    *
    * @param evt  No description provided
    * @return     The ascendMouseEvent value
    */
   public static boolean isAscendMouseEvent (MouseEvent evt)
   {
      if (isADMouseEvent (evt))
      {
         return  ((ADMouseEvent) evt).ascend;
      }
      return false;
   }


   /**
    * Get the descendMouseEvent attribute of the AscendDescendMouseHandler class
    *
    * @param evt  No description provided
    * @return     The descendMouseEvent value
    */
   public static boolean isDescendMouseEvent (MouseEvent evt)
   {
      if (isADMouseEvent (evt))
      {
         return ! ((ADMouseEvent) evt).ascend;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.13 $
    */
   public static class ADMouseEvent extends MouseEvent
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private final Component realSource;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      boolean ascend = true;


      /**
       * Constructor for class ADMouseEvent
       *
       * @param source        No description provided
       * @param realSource    No description provided
       * @param id            No description provided
       * @param when          No description provided
       * @param modifiers     No description provided
       * @param x             No description provided
       * @param y             No description provided
       * @param clickCount    No description provided
       * @param popupTrigger  No description provided
       */
      public ADMouseEvent (Component source, Component realSource, int id, long when, int modifiers,
                           int x, int y, int clickCount, boolean popupTrigger)
      {
         super (source, id, when, modifiers, x, y, clickCount, popupTrigger);
         this.realSource = realSource;
      }


      /**
       * Get the realSource attribute of the ADMouseEvent object
       *
       * @return   The realSource value
       */
      public Component getRealSource()
      {
         return this.realSource;
      }


      /**
       * Get the ascend attribute of the ADMouseEvent object
       *
       * @return   The ascend value
       */
      public boolean isAscend()
      {
         return this.ascend;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.13 $
    */
   public static interface Ascend
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.13 $
    */
   public static interface Descend
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static transient ADHandler adHandler = new ADHandler();


   /**
    * Get the aDHandler attribute of the AscendDescendMouseHandler class
    *
    * @return   The aDHandler value
    */
   protected static ADHandler getADHandler()
   {
      return adHandler;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.13 $
    */
   private final static class ADHandler extends AscendDescendMouseHandler
   {
      /**
       * Constructor for class ADHandler
       */
      private ADHandler()
      {
         super (null);
      }


      /**
       * Access method for an one to n association.
       *
       * @param l  The object added.
       */
      public void addMouseListener (MouseListener l)
      {
         throw new UnsupportedOperationException();
      }


      /**
       * Access method for an one to n association.
       *
       * @param l  The object added.
       */
      public void addMouseMotionListener (MouseMotionListener l)
      {
         throw new UnsupportedOperationException();
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param l  No description provided
       */
      public synchronized void removeMouseListener (MouseListener l) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param l  No description provided
       */
      public synchronized void removeMouseMotionListener (MouseMotionListener l) { }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static Consumer consumer = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static AscendConsumer ascendConsumer = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static DescendConsumer descendConsumer = null;


   /**
    * Get the consumer attribute of the AscendDescendMouseHandler class
    *
    * @return   The consumer value
    */
   public static Consumer getConsumer()
   {
      if (consumer == null)
      {
         consumer = new Consumer();
      }
      return consumer;
   }


   /**
    * Get the ascendConsumer attribute of the AscendDescendMouseHandler class
    *
    * @return   The ascendConsumer value
    */
   public static AscendConsumer getAscendConsumer()
   {
      if (ascendConsumer == null)
      {
         ascendConsumer = new AscendConsumer();
      }
      return ascendConsumer;
   }


   /**
    * Get the descendConsumer attribute of the AscendDescendMouseHandler class
    *
    * @return   The descendConsumer value
    */
   public static DescendConsumer getDescendConsumer()
   {
      if (descendConsumer == null)
      {
         descendConsumer = new DescendConsumer();
      }
      return descendConsumer;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.13 $
    */
   public static class Consumer implements MouseInputListener
   {
      /*
       *  package
       */
      /**
       * Constructor for class Consumer
       */
      Consumer() { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mousePressed (MouseEvent e)
      {
         e.consume();
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseReleased (MouseEvent e)
      {
         e.consume();
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseClicked (MouseEvent e)
      {
         e.consume();
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseEntered (MouseEvent e)
      {
         e.consume();
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseExited (MouseEvent e)
      {
         e.consume();
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseMoved (MouseEvent e)
      {
         e.consume();
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseDragged (MouseEvent e)
      {
         e.consume();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.13 $
    */
   public static class AscendConsumer extends Consumer implements Ascend
   {
      /*
       *  package
       */
      /**
       * Constructor for class AscendConsumer
       */
      AscendConsumer() { }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.13 $
    */
   public static class DescendConsumer extends Consumer implements Descend
   {
      /*
       *  package
       */
      /**
       * Constructor for class DescendConsumer
       */
      DescendConsumer() { }
   }
}

/*
 * $Log: AscendDescendMouseHandler.java,v $
 * Revision 1.13  2004/10/22 16:41:35  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
