/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.swing.JCollapsable;


/**
 * This listener collapses or uncollapses a collapsable component.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.14 $
 */
public class CollapsableMouseListener implements MouseListener, AscendDescendMouseHandler.Descend
{
   /**
    * Internal used attribute to implement the Singleton design pattern. Only one system wide
    * instance of this listener is needed.
    */
   private static CollapsableMouseListener listener = null;


   /**
    * The private constructor of the Singleton design pattern. The constructor is defined private
    * and is empty.
    */
   private CollapsableMouseListener() { }


   /**
    * The public access method of the Singleton design pattern to get the system wide instance.
    * This method initializes the system wide instance when it is called the first time.
    *
    * @return   No description provided
    */
   public static CollapsableMouseListener get()
   {
      if (listener == null)
      {
         listener = new CollapsableMouseListener();
      } // end of if ()
      return listener;
   }


   /**
    * Internal used rectangle to decide if the mouse event occured on the collapse button of
    * the JCollapsable component.
    */
   private Rectangle collapsableRect = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param collapsable  No description provided
    */
   private void refresh (JCollapsable collapsable)
   {
      collapsable.setPreferredSize (null);
      JComponent parent = (JComponent) collapsable.getParent();
      if (parent != null)
      {
         while (parent != null && parent.getParent() instanceof JComponent)
         {
            parent.setPreferredSize (null);
            parent = (JComponent) parent.getParent();
         } // end of while ()
         if (parent != null)
         {
            parent.setPreferredSize (null);
            parent.validate();
         }
      } // end of if ()
   }


   /**
    * Implements the interface method mouseClicked of the MouseListener interface. if the mouse
    * was clicked on the collapse button of a collapsable component this method toggles the
    * collapsed status of the component.
    *
    * @param event  No description provided
    */
   public void mouseClicked (MouseEvent event)
   {
      if (event.getSource() instanceof JCollapsable)
      {
         JCollapsable collapsable = (JCollapsable) event.getSource();
         proofCollapsable (collapsable, event);
         if (collapsableRect.contains (event.getPoint()))
         {
            collapsable.toggleCollapsed();
            refresh (collapsable);
            event.consume();
         } // end of if ()
      } // end of if ()
   }


   /**
    * Implements the interface method mouseEntered of the MouseListener interface. This method
    * is empty.
    *
    * @param event  No description provided
    */
   public void mouseEntered (MouseEvent event) { }


   /**
    * Implements the interface method mouseExited of the MouseListener interface. This method
    * is empty.
    *
    * @param event  No description provided
    */
   public void mouseExited (MouseEvent event) { }


   /**
    * Implements the interface method mousePressed of the MouseListener interface. This method
    * is empty.
    *
    * @param event  No description provided
    */
   public void mousePressed (MouseEvent event) { }


   /**
    * Implements the interface method mouseReleased of the MouseListener interface. This method
    * is empty.
    *
    * @param event  No description provided
    */
   public void mouseReleased (MouseEvent event) { }


   /**
    * proofs if the mouse event occured on the collapse button of the collapsable component.
    *
    * @param tmpCollapsable  No description provided
    * @param event           No description provided
    */
   private void proofCollapsable (JCollapsable tmpCollapsable, MouseEvent event)
   {
      if (collapsableRect == null)
      {
         collapsableRect = new Rectangle();
         collapsableRect.width = 9;
         collapsableRect.height = 9;
      } // end of if ()

      Rectangle tmpRect = tmpCollapsable.getBounds();
      collapsableRect.x = tmpRect.width - 9 - tmpCollapsable.getInsetWidth();
      collapsableRect.y = tmpRect.height - 9;
   }
}

/*
 * $Log: CollapsableMouseListener.java,v $
 * Revision 1.14  2004/10/20 17:49:43  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
