/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class ForegroundHighlighter implements SelectionListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String OLDCOLOR_CLIENTPROPERTY = ForegroundHighlighter.class.getName() + "::oldColor";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static ForegroundHighlighter singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static ForegroundHighlighter get()
   {
      if (singleton == null)
      {
         singleton = new ForegroundHighlighter();
      }

      return singleton;
   }


   /**
    * The default constructor is empty.
    */
   private ForegroundHighlighter() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void selectionChanged (SelectionEvent event)
   {
      JComponent source = (JComponent) event.getSource();
      if (event.isSelected())
      {
         Color color = event.isFocused() ? FSAObject.COLOR_FOCUSED : FSAObject.COLOR_SELECTED;
         setOldColor (source, source.getForeground());
         source.setForeground (color);
      }
      else
      {
         Color color = getOldColor (source);
         if (color != null)
         {
            setOldColor (source, null);
            source.setForeground (color);
         }
      }
      source.repaint();
   }


   /**
    * Sets the oldColor attribute of the ForegroundHighlighter object
    *
    * @param comp  The new oldColor value
    * @param c     The new oldColor value
    * @return      No description provided
    */
   private boolean setOldColor (JComponent comp, Color c)
   {
      Object o = comp.getClientProperty (OLDCOLOR_CLIENTPROPERTY);
      if (o == null || c == null)
      {
         comp.putClientProperty (OLDCOLOR_CLIENTPROPERTY, c);
         return true;
      }
      else if (! (o instanceof Color))
      {
         throw new RuntimeException ("Conflicting Property with name " + OLDCOLOR_CLIENTPROPERTY + " found in " + comp);
      }
      return false;
   }


   /**
    * Get the oldColor attribute of the ForegroundHighlighter object
    *
    * @param comp  No description provided
    * @return      The oldColor value
    */
   private Color getOldColor (JComponent comp)
   {
      Object o = comp.getClientProperty (OLDCOLOR_CLIENTPROPERTY);

      if (o == null || o instanceof Color)
      {
         return (Color) o;
      }
      throw new RuntimeException ("Conflicting Property with name " + OLDCOLOR_CLIENTPROPERTY + " found in " + comp);
   }
}

/*
 * $Log: ForegroundHighlighter.java,v $
 * Revision 1.11  2004/11/03 10:17:54  lowende
 * Javadoc warnings removed.
 *
 */
