/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.*;

import javax.swing.*;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputAdapter;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.swing.LayerManager;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.13 $
 */
public class RectangularSelectionListener extends MouseInputAdapter
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int LAYER = JLayeredPane.DRAG_LAYER.intValue() + 100;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String LAYER_NAME = "RectangularSelectionLayer";

   static
   {
      LayerManager.get().addToLayerPositions (LAYER_NAME, new Integer (LAYER));
   }


   /**
    * The default constructor is empty.
    */
   private RectangularSelectionListener() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static RectangularSelectionListener singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static RectangularSelectionListener get()
   {
      if (singleton == null)
      {
         singleton = new RectangularSelectionListener();
      }

      return singleton;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Point relativePositionOnPress;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JPanel panel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private HashSet selected;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private HashSet unselected;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FSAContainer target;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private LinkedList changed = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mousePressed (MouseEvent e)
   {
      if ( (e.getModifiers() & InputEvent.CTRL_MASK) == 0 &&
          (e.getModifiers() & InputEvent.SHIFT_MASK) == 0)
      {
         SelectionManager.get().clear();
      }
      relativePositionOnPress = e.getPoint();
      JComponent jtarget = (JComponent) e.getSource();
      FSAObject fsa = FSAObject.getFSAObjectFromJComponent (jtarget);

      if (fsa instanceof FSAContainer)
      {
         e.consume();
         target = (FSAContainer) fsa;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseReleased (MouseEvent e)
   {
      if (panel != null)
      {
         Container parent = panel.getParent();
         if (parent != null)
         {
            parent.remove (panel);
            parent.repaint();
         }
         panel = null;
      }
      if (target != null)
      {
         e.consume();
      }

      target = null;
      relativePositionOnPress = null;
      unselected = null;
      selected = null;
      changed = null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseDragged (MouseEvent e)
   {
      if (target != null)
      {
         e.consume();

         SelectionManager manager = SelectionManager.get();
         if (panel == null)
         {
            panel = new JPanel();
            panel.setOpaque (false);
            panel.setBorder (new LineBorder (ColorsPreferences.get().SELECTION_RECT));
            LayerManager.setLayerType (panel, LAYER_NAME);
            target.getJComponent().add (panel);
         }
         if (selected == null || unselected == null)
         {
            int maxSize = 100;

            if (target.getChildConnector() != null)
            {
               maxSize = target.getChildConnector().getComponentCount();
            }

            unselected = new HashSet (maxSize);
            selected = new HashSet (maxSize);

            Iterator childIter = target.iteratorOfChildren();
            while (childIter.hasNext())
            {
               FSAObject child = (FSAObject) childIter.next();

               if (child.isSelected())
               {
                  selected.add (child);
               }
               else
               {
                  unselected.add (child);
               }
            }
         }

         Point newLocation = e.getPoint();
         if (relativePositionOnPress == null)
         {
            relativePositionOnPress = newLocation;
         }

         Rectangle bounds =
            new Rectangle (Math.min (newLocation.x, relativePositionOnPress.x),
            Math.min (newLocation.y, relativePositionOnPress.y),
            Math.abs (newLocation.x - relativePositionOnPress.x),
            Math.abs (newLocation.y - relativePositionOnPress.y));
         Rectangle oldBounds = panel.getBounds();
         panel.setBounds (bounds);

         if (!bounds.contains (oldBounds))
         {
            if (changed == null)
            {
               changed = new LinkedList();
            }

            Rectangle[] removedAreas = SwingUtilities.computeDifference (oldBounds, bounds);
            Iterator selIter = selected.iterator();

            while (selIter.hasNext())
            {
               FSAObject selObject = (FSAObject) selIter.next();
               JComponent selComp = selObject.getJComponent();

               if (selComp != null)
               {
                  Rectangle selBounds = selComp.getBounds();

                  for (int i = 0; i < removedAreas.length; i++)
                  {
                     if (removedAreas[i].intersects (selBounds))
                     {
                        manager.setSelected (selObject, false, true);
                        selIter.remove();
                        changed.add (selObject);
                        break;
                     }
                  }
               }
            }
         }

         if (!oldBounds.contains (bounds))
         {
            Iterator unselIter = unselected.iterator();

            while (unselIter.hasNext())
            {
               FSAObject unselObject = (FSAObject) unselIter.next();
               JComponent unselComp = unselObject.getJComponent();

               if (unselComp != null)
               {
                  Rectangle unselBounds = unselComp.getBounds();

                  if (bounds.contains (unselBounds))
                  {
                     manager.setSelected (unselObject, true, true);
                     unselIter.remove();
                     selected.add (unselObject);
                     break;
                  }
               }
            }
         }

         if (changed != null)
         {
            unselected.addAll (changed);
            changed.clear();
         }
      }
   }
}

/*
 * $Log: RectangularSelectionListener.java,v $
 * Revision 1.13  2004/11/03 10:17:55  lowende
 * Javadoc warnings removed.
 *
 */
